/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import divinerpg.client.models.ModelHat;
import divinerpg.util.Utils;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerHatRender<T extends PlayerEntity, M extends PlayerModel<T>>
extends LayerRenderer<T, M> {
    private ModelHat modelHat;
    private ResourceLocation dev = new ResourceLocation("divinerpg", "textures/model/devhats/hat_red.png");
    private ResourceLocation tester = new ResourceLocation("divinerpg", "textures/model/devhats/hat_blue.png");
    private ResourceLocation artist = new ResourceLocation("divinerpg", "textures/model/devhats/hat_purple.png");
    private ResourceLocation special = new ResourceLocation("divinerpg", "textures/model/devhats/hat_yellow.png");
    private ResourceLocation friend = new ResourceLocation("divinerpg", "textures/model/devhats/hat_pink.png");

    public PlayerHatRender(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
        this.modelHat = new ModelHat((PlayerModel)this.func_215332_c());
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        UUID id;
        if (entity != null && (Utils.isDeveloperName(id = entity.func_110124_au()) || Utils.isTesterName(id) || Utils.isFriend(id) || Utils.isSpecial(id) || Utils.isArtist(id))) {
            if (entity.func_213453_ef()) {
                matrixStackIn.func_227861_a_(0.0, (double)0.2f, 0.0);
            }
            ((PlayerModel)this.func_215332_c()).func_217111_a((EntityModel)this.modelHat);
            this.modelHat.func_212843_a_((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            this.modelHat.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTextureLocation(entity)));
            this.modelHat.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (entity != null) {
            UUID id = entity.func_110124_au();
            if (Utils.isDeveloperName(id)) {
                return this.dev;
            }
            if (Utils.isSpecial(id)) {
                return this.special;
            }
            if (Utils.isTesterName(id)) {
                return this.tester;
            }
            if (Utils.isArtist(id)) {
                return this.artist;
            }
            if (Utils.isFriend(id)) {
                return this.friend;
            }
        }
        return null;
    }
}

