/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat;

import divinerpg.config.Config;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.KeyRegistry;
import divinerpg.registries.LootTableRegistry;
import jeresources.api.IDungeonRegistry;
import jeresources.api.IJERAPI;
import jeresources.api.IPlantRegistry;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.JERPlugin;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class JERCompat {
    @JERPlugin
    public static IJERAPI jerAPI;

    public static void init(FMLCommonSetupEvent event) {
        if (jerAPI == null) {
            return;
        }
        JERCompat.initOreGen();
        JERCompat.initPlants();
    }

    private static void initDungeonLoot() {
        IDungeonRegistry dungeonRegistry = jerAPI.getDungeonRegistry();
        dungeonRegistry.registerChest("Iceika Chest", LootTableRegistry.ICEIKA_CHEST_DUNGEON);
        dungeonRegistry.registerChest("Iceika Hut Chest", LootTableRegistry.ICEIKA_CHEST_HUT);
        dungeonRegistry.registerChest("Crypt Loot", LootTableRegistry.CRYPT_LOOT);
        dungeonRegistry.registerChest("Lower Temple Loot", LootTableRegistry.TEMPLE_LOOT_BOTTOM);
        dungeonRegistry.registerChest("Middle Temple Loot", LootTableRegistry.TEMPLE_LOOT_MIDDLE);
        dungeonRegistry.registerChest("Higher Temple Loot", LootTableRegistry.TEMPLE_LOOT_TOP);
        dungeonRegistry.registerChest("Quadrotic Post Loot", LootTableRegistry.QUADROTIC_POST_LOOT);
        dungeonRegistry.registerChest("Karos Mad House Loot", LootTableRegistry.KAROS_MADHOUSE_LOOT);
        dungeonRegistry.registerChest("Raglok Chamber Loot", LootTableRegistry.RAGLOK_CHAMBER_LOOT);
        dungeonRegistry.registerChest("Wreck Hall Loot", LootTableRegistry.WRECK_HALL_LOOT);
    }

    private static void initOreGen() {
        IWorldGenRegistry worldGenRegistry = jerAPI.getWorldGenRegistry();
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.arlemiteOre), (DistributionBase)new DistributionSquare(((Integer)Config.arlemiteTries.get()).intValue(), ((Integer)Config.arlemiteVeinSize.get()).intValue(), 0, ((Integer)Config.arlemiteMaxHeight.get()).intValue()), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.realmiteOre), (DistributionBase)new DistributionSquare(((Integer)Config.realmiteTries.get()).intValue(), ((Integer)Config.realmiteVeinSize.get()).intValue(), 0, ((Integer)Config.realmiteMaxHeight.get()).intValue()), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.rupeeOre), (DistributionBase)new DistributionSquare(((Integer)Config.rupeeTries.get()).intValue(), ((Integer)Config.rupeeVeinSize.get()).intValue(), 0, ((Integer)Config.rupeeMaxHeight.get()).intValue()), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.torriditeOre), (DistributionBase)new DistributionSquare(((Integer)Config.netherTries.get()).intValue(), ((Integer)Config.netherVein.get()).intValue(), 0, 256), new Restriction(new DimensionRestriction(World.field_234919_h_)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.bloodgemOre), (DistributionBase)new DistributionSquare(((Integer)Config.netherTries.get()).intValue(), ((Integer)Config.netherVein.get()).intValue(), 0, 256), new Restriction(new DimensionRestriction(World.field_234919_h_)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.edenOre), (DistributionBase)new DistributionSquare(((Integer)Config.twilightTries.get()).intValue(), ((Integer)Config.twilightVein.get()).intValue(), 0, 256), new Restriction(new DimensionRestriction(KeyRegistry.EDEN_WORLD)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.wildwoodOre), (DistributionBase)new DistributionSquare(((Integer)Config.twilightTries.get()).intValue(), ((Integer)Config.twilightVein.get()).intValue(), 0, 256), new Restriction(new DimensionRestriction(KeyRegistry.WILDWOOD_WORLD)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.apalachiaOre), (DistributionBase)new DistributionSquare(((Integer)Config.twilightTries.get()).intValue(), ((Integer)Config.twilightVein.get()).intValue(), 0, 256), new Restriction(new DimensionRestriction(KeyRegistry.APALACHIA_WORLD)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.skythernOre), (DistributionBase)new DistributionSquare(((Integer)Config.twilightTries.get()).intValue(), ((Integer)Config.twilightVein.get()).intValue(), 0, 256), new Restriction(new DimensionRestriction(KeyRegistry.SKYTHERN_WORLD)), new LootDrop[0]);
        worldGenRegistry.register(new ItemStack((IItemProvider)BlockRegistry.mortumOre), (DistributionBase)new DistributionSquare(((Integer)Config.twilightTries.get()).intValue(), ((Integer)Config.twilightVein.get()).intValue(), 0, 256), new Restriction(new DimensionRestriction(KeyRegistry.MORTUM_WORLD)), new LootDrop[0]);
    }

    private static void initPlants() {
        IPlantRegistry plantRegistry = jerAPI.getPlantRegistry();
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.moonbulbSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.moonbulb), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.tomatoSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.tomato), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.whiteMushroomSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.whiteMushroom), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.aquamarineSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.aquamarine), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.eucalyptusRootSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)BlockRegistry.eucalyptusLog), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.firestockSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.firestock), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.hitchakSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.hitchak), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.lamonaSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.lamona), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.marsineSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.marsine), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.pinflySeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.pinfly), 1, 1)});
        plantRegistry.register(new ItemStack((IItemProvider)ItemRegistry.veiloSeeds), new PlantDrop[]{new PlantDrop(new ItemStack((IItemProvider)ItemRegistry.veilo), 1, 1)});
    }
}

