/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei;

import divinerpg.DivineRPG;
import divinerpg.compat.jei.category.ArcaniumExtractorCategory;
import divinerpg.compat.jei.category.InfusionTableCategory;
import divinerpg.recipe.ArcaniumExtractorRecipe;
import divinerpg.recipe.InfusionTableRecipe;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.RecipeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public final class JEICompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("divinerpg", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.coalstoneFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.demonFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.greenlightFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.moltenFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.moonlightFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.oceanfireFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.whitefireFurnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.arcaniumExtractor), new ResourceLocation[]{ArcaniumExtractorCategory.ARCANIUM_EXTRACTOR});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.infusionTable), new ResourceLocation[]{InfusionTableCategory.TEXTURE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ArcaniumExtractorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusionTableCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Results recipes = JEICompat.getAllRecipes();
        registration.addRecipes(recipes.arcaniumExtractorRecipes(), ArcaniumExtractorCategory.ARCANIUM_EXTRACTOR);
        registration.addRecipes(recipes.infusionTableRecipes(), InfusionTableCategory.TEXTURE);
    }

    public static Results getAllRecipes() {
        Results results = new Results();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        results.arcaniumExtractorRecipes.addAll(JEICompat.getRecipes(recipeManager, RecipeRegistry.RecipeTypes.ARCANIUM_EXTRACTOR_RECIPE_TYPE));
        results.infusionTableRecipes.addAll(JEICompat.getRecipes(recipeManager, DivineRPG.INFUSION_TABLE_RECIPE));
        return results;
    }

    private static <C extends IInventory, T extends IRecipe<C>> Collection<T> getRecipes(RecipeManager recipeManager, IRecipeType<T> recipeType) {
        Map recipesMap = recipeManager.func_215366_a(recipeType);
        return recipesMap.values();
    }

    public static class Results {
        private final List<ArcaniumExtractorRecipe> arcaniumExtractorRecipes = new ArrayList<ArcaniumExtractorRecipe>();
        private final List<InfusionTableRecipe> infusionTableRecipes = new ArrayList<InfusionTableRecipe>();

        public List<ArcaniumExtractorRecipe> arcaniumExtractorRecipes() {
            return this.arcaniumExtractorRecipes;
        }

        public List<InfusionTableRecipe> infusionTableRecipes() {
            return this.infusionTableRecipes;
        }
    }
}

