/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_WORLD = "world gen";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue welcomeMessage;
    public static ForgeConfigSpec.BooleanValue hideArcanaBar;
    public static ForgeConfigSpec.IntValue arlemiteVeinSize;
    public static ForgeConfigSpec.IntValue arlemiteMaxHeight;
    public static ForgeConfigSpec.IntValue arlemiteTries;
    public static ForgeConfigSpec.IntValue realmiteVeinSize;
    public static ForgeConfigSpec.IntValue realmiteMaxHeight;
    public static ForgeConfigSpec.IntValue realmiteTries;
    public static ForgeConfigSpec.IntValue rupeeVeinSize;
    public static ForgeConfigSpec.IntValue rupeeMaxHeight;
    public static ForgeConfigSpec.IntValue rupeeTries;
    public static ForgeConfigSpec.IntValue netherVein;
    public static ForgeConfigSpec.IntValue netherTries;
    public static ForgeConfigSpec.IntValue twilightVein;
    public static ForgeConfigSpec.IntValue twilightTries;
    public static ForgeConfigSpec.IntValue arcanaX;
    public static ForgeConfigSpec.IntValue arcanaY;
    public static ForgeConfigSpec.IntValue maxArcana;

    private static void setupConfig() {
        COMMON_BUILDER.comment("General Settings").push(CATEGORY_GENERAL);
        welcomeMessage = COMMON_BUILDER.comment("Enable welcome messages").define("welcomeMessage", true);
        hideArcanaBar = COMMON_BUILDER.comment("Hide Arcana bar unless depleted").define("hideArcanaBar", true);
        arcanaX = COMMON_BUILDER.comment("arcana x").defineInRange("arcanaX", 111, 1, 255);
        arcanaY = COMMON_BUILDER.comment("arcana y").defineInRange("arcanaY", 18, 1, 255);
        maxArcana = COMMON_BUILDER.comment("Maximum stored arcana").defineInRange("maxArcana", 200, 1, 10000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("World Gen Settings").push(CATEGORY_WORLD);
        arlemiteVeinSize = COMMON_BUILDER.comment("Arlemite ore vein size").defineInRange("arlemiteVein", 5, 1, 256);
        arlemiteMaxHeight = COMMON_BUILDER.comment("Arlemite ore maximum spawn height").defineInRange("arlemiteMax", 16, 1, 256);
        arlemiteTries = COMMON_BUILDER.comment("Arlemite ore popularity").defineInRange("arlemiteTries", 4, 1, 32);
        realmiteVeinSize = COMMON_BUILDER.comment("Realmite ore vein size").defineInRange("realmiteVein", 5, 1, 256);
        realmiteMaxHeight = COMMON_BUILDER.comment("Realmite ore maximum spawn height").defineInRange("realmiteMax", 48, 1, 256);
        realmiteTries = COMMON_BUILDER.comment("Realmite ore popularity").defineInRange("realmiteTries", 8, 1, 32);
        rupeeVeinSize = COMMON_BUILDER.comment("Rupee ore vein size").defineInRange("rupeeVein", 5, 1, 256);
        rupeeMaxHeight = COMMON_BUILDER.comment("Rupee ore maximum spawn height").defineInRange("rupeeMax", 16, 1, 256);
        rupeeTries = COMMON_BUILDER.comment("Rupee ore popularity").defineInRange("rupeeTries", 4, 1, 32);
        netherVein = COMMON_BUILDER.comment("Nether ore vein size").defineInRange("netherVein", 10, 1, 32);
        netherTries = COMMON_BUILDER.comment("Nether ore popularity").defineInRange("netherTries", 8, 1, 32);
        twilightVein = COMMON_BUILDER.comment("Twilight ore vein size").defineInRange("twilightVein", 10, 1, 32);
        twilightTries = COMMON_BUILDER.comment("Twilight ore popularity").defineInRange("twilightTries", 8, 1, 32);
        COMMON_BUILDER.pop();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        COMMON_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        COMMON_BUILDER.comment("World Gen settings").push(CATEGORY_WORLD);
        COMMON_BUILDER.pop();
        Config.setupConfig();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

