/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.ai;

import divinerpg.enums.ILaunchFireBall;
import divinerpg.enums.ILaunchThrowable;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class AIDivineFireballAttack
extends Goal {
    private final MobEntity parentEntity;
    private final BiFunction<MobEntity, Entity, Entity> createFireballFunc;
    public int attackTimer;
    private final int attackDelay;
    private final int maxDistance;
    private final SoundEvent beforeShoot;
    private final SoundEvent onShoot;

    public AIDivineFireballAttack(MobEntity parentEntity, BiFunction<MobEntity, Entity, Entity> createFireballFunc, int attackDelay, int maxDistance, SoundEvent beforeShoot, SoundEvent onShoot) {
        this.parentEntity = parentEntity;
        this.createFireballFunc = createFireballFunc;
        this.attackDelay = attackDelay;
        this.maxDistance = maxDistance;
        this.beforeShoot = beforeShoot;
        this.onShoot = onShoot;
    }

    public AIDivineFireballAttack(MobEntity ghast, ILaunchFireBall func) {
        this(ghast, func::createFireball, 20, 64, SoundEvents.field_187559_bL, SoundEvents.field_187557_bK);
    }

    public AIDivineFireballAttack(MobEntity ghast, ILaunchFireBall createFireball, SoundEvent onShoot) {
        this(ghast, createFireball::createFireball, 20, 64, null, onShoot);
    }

    public AIDivineFireballAttack(MobEntity ghast, ILaunchThrowable createThrowable, SoundEvent onShoot) {
        this(ghast, createThrowable::createFireball, 20, 64, null, onShoot);
    }

    public boolean func_75253_b() {
        return super.func_75253_b();
    }

    public void func_75249_e() {
        this.attackTimer = 0;
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        LivingEntity entitylivingbase;
        if (this.parentEntity != null && (entitylivingbase = this.parentEntity.func_70638_az()) != null) {
            if (Math.sqrt(entitylivingbase.func_70032_d((Entity)this.parentEntity)) < (double)this.maxDistance && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == this.attackDelay - 10) {
                    this.playSound(this.beforeShoot);
                }
                if (this.attackTimer == this.attackDelay) {
                    this.playSound(this.onShoot);
                    world.func_217376_c(this.createFireballFunc.apply(this.parentEntity, (Entity)entitylivingbase));
                    this.attackTimer = this.attackDelay * -2;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.attackTimer <= 10) {
                // empty if block
            }
        }
    }

    public boolean func_75250_a() {
        return this.parentEntity.func_70643_av() != null;
    }

    private void playSound(SoundEvent event) {
        if (this.parentEntity == null || this.parentEntity.field_70170_p == null || event == null) {
            return;
        }
        Random rand = this.parentEntity.field_70170_p.field_73012_v;
        this.parentEntity.field_70170_p.func_184133_a(null, this.parentEntity.func_233580_cy_(), event, SoundCategory.HOSTILE, 10.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
    }
}

