/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.ai;

import divinerpg.entities.vanilla.overworld.EntityAequorea;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;

public class TurtleEatAequorea
extends Goal {
    TurtleEntity turtle;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public TurtleEatAequorea(TurtleEntity turtle, double speed, boolean followAtAllCosts) {
        this.turtle = turtle;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = followAtAllCosts;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        return this.turtle.func_70638_az() instanceof EntityAequorea;
    }

    public boolean func_75253_b() {
        LivingEntity livingentity = this.turtle.func_70638_az();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.turtle.func_70661_as().func_75500_f();
        }
        if (!this.turtle.func_213389_a(livingentity.func_233580_cy_())) {
            return false;
        }
        return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
    }

    public void func_75249_e() {
        this.turtle.func_70661_as().func_75484_a(this.path, this.speedModifier);
        this.turtle.func_213395_q(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void func_75251_c() {
        LivingEntity livingentity = this.turtle.func_70638_az();
        if (!EntityPredicates.field_188444_d.test(livingentity)) {
            this.turtle.func_70624_b((LivingEntity)null);
        }
        this.turtle.func_213395_q(false);
        this.turtle.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.turtle.func_70638_az();
        this.turtle.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.turtle.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.turtle.func_70635_at().func_75522_a((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.func_70092_e(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.turtle.func_70681_au().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.func_226277_ct_();
            this.pathedTargetY = livingentity.func_226278_cu_();
            this.pathedTargetZ = livingentity.func_226281_cx_();
            this.ticksUntilNextPathRecalculation = 4 + this.turtle.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.turtle.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.turtle.func_70661_as().func_75505_d().func_75870_c()) != null && livingentity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.turtle.func_70661_as().func_75497_a((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity entity, double range) {
        double d0 = this.getAttackReachSqr(entity);
        if (range <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            entity.func_70097_a(new DamageSource("turtle"), entity.func_110143_aJ());
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 20;
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.turtle.func_213311_cf() * 2.0f * this.turtle.func_213311_cf() * 2.0f + p_179512_1_.func_213311_cf();
    }
}

