/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.util.EntityStats;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntityParatiku
extends EntityDivineTameable {
    private static final DataParameter<Byte> HANGING = EntityDataManager.func_187226_a(EntityParatiku.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final EntityPredicate RESTING_TARGETING = new EntityPredicate().func_221013_a(4.0).func_221011_b();
    private BlockPos spawnPosition;

    public EntityParatiku(EntityType<? extends TameableEntity> type, World worldIn, PlayerEntity player) {
        super(type, worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_193101_c(player);
        this.setIsParatikuHanging(true);
    }

    public <T extends Entity> EntityParatiku(EntityType<T> type, World worldIn) {
        super(type, worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.setIsParatikuHanging(true);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_213302_cg() / 2.0f;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return TameableEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, EntityStats.paratikuHealth).func_233815_a_(Attributes.field_233821_d_, EntityStats.paratikuSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.paratikuFollowRange);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HANGING, (Object)0);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity ent) {
    }

    protected void func_85033_bc() {
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float damage, float multiplier) {
        return false;
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    public boolean func_145773_az() {
        return true;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    protected SoundEvent func_184639_G() {
        return this.getIsParatikuHanging() && this.field_70146_Z.nextInt(4) != 0 ? null : SoundEvents.field_187740_w;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187743_y;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187742_x;
    }

    public boolean getIsParatikuHanging() {
        return ((Byte)this.field_70180_af.func_187225_a(HANGING) & 1) != 0;
    }

    public void setIsParatikuHanging(boolean isHanging) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(HANGING);
        if (isHanging) {
            this.field_70180_af.func_187227_b(HANGING, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(HANGING, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = player.func_184586_b(hand);
            Item item = itemstack.func_77973_b();
            if (this.func_70909_n() && item.func_219967_s() != null) {
                if (item.func_219967_s().func_221467_c() && this.func_110143_aJ() < this.func_110138_aP()) {
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    this.func_70691_i(item.func_219967_s().func_221466_a());
                    return ActionResultType.PASS;
                }
                this.func_193101_c(player);
                this.func_70903_f(true);
            }
            return super.func_230254_b_(player, hand);
        }
        return ActionResultType.PASS;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsParatikuHanging()) {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_226288_n_(this.func_226277_ct_(), (double)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0 - (double)this.func_213302_cg(), this.func_226281_cx_());
        } else {
            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b * (double)0.6f, this.func_213322_ci().field_72449_c);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = this.func_233580_cy_();
        BlockPos blockpos1 = blockpos.func_177984_a();
        if (this.getIsParatikuHanging()) {
            boolean flag = this.func_174814_R();
            if (this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos)) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.field_70759_as = this.field_70146_Z.nextInt(360);
                }
                if (this.field_70170_p.func_217370_a(RESTING_TARGETING, (LivingEntity)this) != null) {
                    this.setIsParatikuHanging(false);
                    if (!flag) {
                        this.field_70170_p.func_217378_a((PlayerEntity)null, 1025, blockpos, 0);
                    }
                }
            } else {
                this.setIsParatikuHanging(false);
                if (!flag) {
                    this.field_70170_p.func_217378_a((PlayerEntity)null, 1025, blockpos, 0);
                }
            }
        } else if (this.func_70638_az() != null) {
            if (this.func_70638_az().func_233580_cy_() == null || !this.field_70170_p.func_175623_d(this.func_70638_az().func_233580_cy_()) || this.func_70638_az().func_233580_cy_().func_177956_o() < 1) {
                // empty if block
            }
            if (this.func_70638_az().func_233580_cy_() == null || this.field_70146_Z.nextInt(30) == 0 || this.func_70638_az().func_233580_cy_().func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
                this.func_225653_b_(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(6) - 2.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7));
            }
            double d2 = (double)this.func_70638_az().func_233580_cy_().func_177958_n() + 0.5 - this.func_226277_ct_();
            double d0 = (double)this.func_70638_az().func_233580_cy_().func_177956_o() + 0.1 - this.func_226278_cu_();
            double d1 = (double)this.func_70638_az().func_233580_cy_().func_177952_p() + 0.5 - this.func_226281_cx_();
            Vector3d vector3d = this.func_213322_ci();
            Vector3d vector3d1 = vector3d.func_72441_c((Math.signum(d2) * 0.5 - vector3d.field_72450_a) * (double)0.1f, (Math.signum(d0) * (double)0.7f - vector3d.field_72448_b) * (double)0.1f, (Math.signum(d1) * 0.5 - vector3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vector3d1);
            float f = (float)(MathHelper.func_181159_b((double)vector3d1.field_72449_c, (double)vector3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
            if (this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos1)) {
                this.setIsParatikuHanging(true);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_180136_u()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getIsParatikuHanging()) {
            this.setIsParatikuHanging(false);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(HANGING, (Object)compound.func_74771_c("ParatikuFlags"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.func_184753_b() == null) {
            compound.func_74778_a("Owner", "");
        } else {
            compound.func_74778_a("Owner", this.func_184753_b().toString());
        }
        compound.func_74774_a("ParatikuFlags", ((Byte)this.field_70180_af.func_187225_a(HANGING)).byteValue());
    }
}

