/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntityWraith
extends EntityDivineTameable {
    private static final DataParameter<Byte> DATA_ID_FLAGS = EntityDataManager.func_187226_a(EntityWraith.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final EntityPredicate RESTING_TARGETING = new EntityPredicate().func_221013_a(4.0).func_221011_b();
    private BlockPos targetPosition;

    public EntityWraith(EntityType<? extends TameableEntity> type, World worldIn, PlayerEntity player) {
        super(type, worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_193101_c(player);
        this.setResting(true);
    }

    public <T extends Entity> EntityWraith(EntityType<T> type, World worldIn) {
        super(type, worldIn);
        this.func_70606_j(this.func_110138_aP());
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.5f;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return TameableEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, EntityStats.seimerHealth).func_233815_a_(Attributes.field_233821_d_, EntityStats.seimerSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.seimerFollowRange);
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.func_70909_n()) {
            if (this.func_70877_b(itemstack)) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return ActionResultType.PASS;
            }
            this.func_193101_c(player);
            this.func_70903_f(true);
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s().func_221467_c();
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean attacked;
        float damage = (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b();
        if (this.func_70644_a(Effects.field_76420_g)) {
            damage += (float)(3 << this.func_70660_b(Effects.field_76420_g).func_76458_c());
        }
        if (this.func_70644_a(Effects.field_76437_t)) {
            damage -= (float)(2 << this.func_70660_b(Effects.field_76437_t).func_76458_c());
        }
        int knockback = 0;
        if (entity instanceof LivingEntity) {
            damage += (float)EnchantmentHelper.func_185293_e((LivingEntity)((LivingEntity)entity));
            knockback += EnchantmentHelper.func_77501_a((LivingEntity)((LivingEntity)entity));
        }
        if (attacked = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) {
            int fire;
            if (knockback > 0) {
                entity.func_213293_j((double)(-MathHelper.func_76126_a((float)(this.field_70125_A * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70125_A * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.func_213293_j(this.func_213322_ci().field_72450_a * 0.6, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c * 0.6);
            }
            if ((fire = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
                entity.func_241209_g_(fire * 4);
            }
        }
        return attacked;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.func_184753_b() == null) {
            compound.func_74778_a("Owner", "");
        } else {
            compound.func_74778_a("Owner", this.func_184753_b().toString());
        }
        compound.func_74757_a("Sitting", this.func_233685_eM_());
        compound.func_74774_a("BatFlags", ((Byte)this.field_70180_af.func_187225_a(DATA_ID_FLAGS)).byteValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(DATA_ID_FLAGS, (Object)compound.func_74771_c("BatFlags"));
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return this.isResting() && this.field_70146_Z.nextInt(4) != 0 ? null : SoundRegistry.WRAITH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.WRAITH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.WRAITH_HURT;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity p_82167_1_) {
    }

    protected void func_85033_bc() {
    }

    public boolean isResting() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_ID_FLAGS) & 1) != 0;
    }

    public void setResting(boolean p_82236_1_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_ID_FLAGS);
        if (p_82236_1_) {
            this.field_70180_af.func_187227_b(DATA_ID_FLAGS, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(DATA_ID_FLAGS, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void func_70071_h_() {
        if (this.isResting()) {
            this.func_213317_d(Vector3d.field_186680_a);
            this.func_226288_n_(this.func_226277_ct_(), (double)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0 - (double)this.func_213302_cg(), this.func_226281_cx_());
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = this.func_233580_cy_();
        BlockPos blockpos1 = blockpos.func_177984_a();
        if (this.isResting()) {
            boolean flag = this.func_174814_R();
            if (this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos)) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.field_70759_as = this.field_70146_Z.nextInt(360);
                }
                if (this.field_70170_p.func_217370_a(RESTING_TARGETING, (LivingEntity)this) != null) {
                    this.setResting(false);
                    if (!flag) {
                        this.field_70170_p.func_217378_a((PlayerEntity)null, 1025, blockpos, 0);
                    }
                }
            } else {
                this.setResting(false);
                if (!flag) {
                    this.field_70170_p.func_217378_a((PlayerEntity)null, 1025, blockpos, 0);
                }
            }
        } else {
            if (!(this.targetPosition == null || this.field_70170_p.func_175623_d(this.targetPosition) && this.targetPosition.func_177956_o() >= 1)) {
                this.targetPosition = null;
            }
            if (this.targetPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.targetPosition.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
                this.targetPosition = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(6) - 2.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7));
            }
            double d2 = (double)this.targetPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
            double d0 = (double)this.targetPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
            double d1 = (double)this.targetPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
            Vector3d vector3d = this.func_213322_ci();
            Vector3d vector3d1 = vector3d.func_72441_c((Math.signum(d2) * 0.5 - vector3d.field_72450_a) * (double)0.1f, (Math.signum(d0) * (double)0.7f - vector3d.field_72448_b) * (double)0.1f, (Math.signum(d1) * 0.5 - vector3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vector3d1);
            float f = (float)(MathHelper.func_181159_b((double)vector3d1.field_72449_c, (double)vector3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
            if (this.field_70146_Z.nextInt(100) == 0 && this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos1)) {
                this.setResting(true);
            }
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    public boolean func_145773_az() {
        return true;
    }
}

