/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class EntityDivineFlyingMob
extends FlyingEntity
implements IMob,
IRangedAttackMob {
    private static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = p_213797_0_ -> p_213797_0_.func_70668_bt() != CreatureAttribute.field_223223_b_ && p_213797_0_.func_190631_cK();

    protected EntityDivineFlyingMob(EntityType<? extends FlyingEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return true;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected void addAttackingAI() {
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_82196_d(LivingEntity entity, float range) {
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityDivineFlyingMob parentEntity;

        public RandomFlyGoal(EntityDivineFlyingMob ent) {
            this.parentEntity = ent;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityDivineFlyingMob parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntityDivineFlyingMob ent) {
            super((MobEntity)ent);
            this.parentEntity = ent;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_189654_d(true);
                double d0 = this.field_75646_b - this.field_75648_a.func_226277_ct_();
                double d1 = this.field_75647_c - this.field_75648_a.func_226278_cu_();
                double d2 = this.field_75644_d - this.field_75648_a.func_226281_cx_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_70657_f(0.0f);
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f, 90.0f);
                float f1 = this.field_75648_a.func_233570_aj_() ? (float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)) : (float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233822_e_));
                this.field_75648_a.func_70659_e(f1);
                double d4 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f2 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d4) * 57.2957763671875));
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f2, 20.0f);
                this.field_75648_a.func_70657_f(d1 > 0.0 ? f1 : -f1);
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                    double d5 = vector3d.func_72433_c();
                    if (this.canReach(vector3d = vector3d.func_72432_b(), MathHelper.func_76143_f((double)d5))) {
                        this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
                    } else {
                        this.field_188491_h = MovementController.Action.WAIT;
                    }
                }
            }
        }

        private boolean canReach(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final EntityDivineFlyingMob parentEntity;

        public LookAroundGoal(EntityDivineFlyingMob ent) {
            this.parentEntity = ent;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vector3d vector3d = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70127_C = this.parentEntity.field_70125_A = -((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (livingentity.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = livingentity.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70127_C = this.parentEntity.field_70125_A = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }
}

