/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import com.mojang.serialization.Dynamic;
import divinerpg.entities.ai.TraderAI;
import divinerpg.registries.TraderProfession;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class EntityDivineMerchant
extends VillagerEntity
implements IMerchant {
    protected EntityDivineMerchant(EntityType<? extends EntityDivineMerchant> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, MonsterEntity.class, 8.0f, 0.8, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new TraderAI(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        this.func_213753_a(this.func_213700_eh().func_221126_a((VillagerProfession)TraderProfession.TRADER.get()));
        return data;
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamic) {
        return this.func_230289_cH_().func_233748_a_(dynamic);
    }

    public void func_213770_a(ServerWorld world) {
    }

    protected void func_175500_n() {
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.27);
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return !worldIn.func_226660_f_(pos);
    }

    public float func_205022_a(BlockPos pos, IWorldReader reader) {
        return 0.0f;
    }

    public abstract String[] getChatMessages();

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187914_gn;
    }

    protected ITextComponent func_225513_by_() {
        return this.func_200600_R().func_212546_e();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!this.func_213706_dY().isEmpty() && !this.field_70170_p.field_72995_K) {
            this.func_213762_g(player);
            this.func_70932_a_(player);
            this.func_213707_a(player, this.func_145748_c_(), 1);
            player.func_145747_a((ITextComponent)new TranslationTextComponent((String)Arrays.stream(this.getChatMessages()).iterator().next()), player.func_110124_au());
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    protected void func_213762_g(PlayerEntity player) {
        int reputation = this.func_223107_f(player);
        if (reputation != 0) {
            for (MerchantOffer offer : this.func_213706_dY()) {
                offer.func_222207_a(-MathHelper.func_76141_d((float)((float)reputation * offer.func_222211_m())));
            }
        }
    }

    public static class DivineTrades
    implements VillagerTrades.ITrade {
        private ItemStack input2;
        private ItemStack input1;
        private ItemStack output;
        private int xp;
        private int stock;

        public DivineTrades(ItemStack input1, ItemStack input2, ItemStack output, int stock, int xp) {
            this.xp = xp;
            this.stock = stock + 1;
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
        }

        public DivineTrades(ItemStack input1, ItemStack output, int stock, int xp) {
            this(input1, ItemStack.field_190927_a, output, stock, xp);
        }

        public MerchantOffer func_221182_a(Entity tradeEnt, Random rand) {
            return new MerchantOffer(this.input1, this.input2, this.output, this.stock, this.xp, 0.0f);
        }
    }
}

