/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.entities.base.EntityDivineMob;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityPeacefulUntilAttacked
extends EntityDivineMob {
    protected static final DataParameter<Integer> ANGER = EntityDataManager.func_187226_a(EntityPeacefulUntilAttacked.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<String> TARGET = EntityDataManager.func_187226_a(EntityPeacefulUntilAttacked.class, (IDataSerializer)DataSerializers.field_187194_d);
    private int angerLevel;
    private UUID angerTargetUUID;

    public EntityPeacefulUntilAttacked(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGER, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Anger", (int)((short)this.angerLevel));
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.angerLevel = compound.func_74765_d("Anger");
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            PlayerEntity entityplayer = this.field_70170_p.func_217371_b(this.angerTargetUUID);
            this.func_70624_b((LivingEntity)entityplayer);
            if (entityplayer != null) {
                this.func_70624_b((LivingEntity)entityplayer);
                this.field_110153_bc = this.func_142015_aE();
            }
        }
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.isAngry()) {
            this.addAttackingAI();
        }
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(pos.func_177977_b()).func_215688_a((IBlockReader)worldIn, pos.func_177977_b(), typeIn);
    }

    public void func_70624_b(@Nullable LivingEntity livingBase) {
        super.func_70624_b(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76364_f();
        if (entity instanceof PlayerEntity) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    private void becomeAngryAt(Entity target) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        if (target instanceof LivingEntity) {
            this.func_70624_b((LivingEntity)target);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isAngry()) {
            return super.func_70652_k(entity);
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isAngry()) {
            --this.angerLevel;
            this.addAttackingAI();
        }
    }
}

