/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.blocks.vethea.BlockHelioticBeam;
import divinerpg.blocks.vethea.BlockKarosDispenser;
import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import divinerpg.util.LocalizeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityKaros
extends EntityDivineBoss {
    private int ability = 0;
    private final int DEFAULT = 0;
    private final int CEILING = 1;
    private final int CANNONS = 2;
    private final int FLOOR = 3;
    private int abilityCooldown;
    private boolean hasLoadedBlocks = false;
    private List<BlockPos> ceiling = new ArrayList<BlockPos>();
    private List<BlockPos> cannons = new ArrayList<BlockPos>();

    public EntityKaros(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70619_bc() {
        this.manageAbilities();
        super.func_70619_bc();
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(8, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 1.0f, 1.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PiglinEntity.class}));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void manageAbilities() {
        block9: {
            block8: {
                if (this.abilityCooldown != 0) break block8;
                this.abilityCooldown = 200;
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.ability = 1;
                        this.func_184185_a(SoundRegistry.CEILING_EXPLOSIONS, 1.0f, 1.0f);
                        if (!this.field_70170_p.field_72995_K) {
                            List players = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
                            for (PlayerEntity p : players) {
                                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)p, "message.karos.explosion", new Object[0]), p.func_110124_au());
                            }
                        }
                        break block9;
                    }
                    case 1: {
                        this.ability = 2;
                        break;
                    }
                    case 2: {
                        this.ability = 3;
                        break;
                    }
                }
                break block9;
            }
            if (this.abilityCooldown > 0) {
                --this.abilityCooldown;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (source.func_94541_c()) {
            return false;
        }
        return super.func_70097_a(source, par2);
    }

    @Override
    public void func_70071_h_() {
        BlockPos currentPos;
        Block currentBlock;
        int var2;
        super.func_70071_h_();
        if (!this.hasLoadedBlocks) {
            if (!this.field_70170_p.field_72995_K) {
                List players = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
                for (PlayerEntity p : players) {
                    this.field_70170_p.func_184133_a(p, p.func_233580_cy_(), SoundRegistry.KAROS_INTRO, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)p, "message.karos.game", new Object[0]), p.func_110124_au());
                    p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)p, "message.karos.begin", new Object[0]), p.func_110124_au());
                }
            }
            for (int x = -40; x < 40; ++x) {
                for (int y = -5; y < 20; ++y) {
                    for (int z = -40; z < 40; ++z) {
                        BlockPos currentPos2 = this.func_233580_cy_().func_177982_a(x, y, z);
                        Block currentBlock2 = this.field_70170_p.func_180495_p(currentPos2).func_177230_c();
                        if (currentBlock2 == BlockRegistry.helioticBeam) {
                            this.ceiling.add(currentPos2);
                            continue;
                        }
                        if (currentBlock2 != BlockRegistry.karosDispenser) continue;
                        this.cannons.add(currentPos2);
                    }
                }
            }
            this.hasLoadedBlocks = true;
        }
        if (this.ability == 1 && this.ceiling.size() != 0) {
            var2 = this.field_70146_Z.nextInt(46);
            if (this.abilityCooldown % 8 == 0 && (currentBlock = this.field_70170_p.func_180495_p(currentPos = this.ceiling.get(this.field_70146_Z.nextInt(this.ceiling.size()))).func_177230_c()) instanceof BlockHelioticBeam) {
                ((BlockHelioticBeam)currentBlock).dropBomb(this.field_70170_p, currentPos);
            }
        } else if (this.ability == 2 && this.cannons.size() != 0) {
            var2 = this.field_70146_Z.nextInt(36);
            if (this.abilityCooldown % 4 == 0) {
                currentPos = this.cannons.get(this.field_70146_Z.nextInt(this.cannons.size()));
                currentBlock = this.field_70170_p.func_180495_p(currentPos).func_177230_c();
                if (currentBlock instanceof BlockKarosDispenser) {
                    ((BlockKarosDispenser)currentBlock).dispenseFrom(this.field_70170_p.func_73046_m().func_71218_a(this.field_70170_p.func_234923_W_()), currentPos);
                }
            } else if (this.ability == 3) {
                for (int i = 0; i < 3; ++i) {
                    for (double var4 = 0.0; var4 < Math.PI * 2; var4 += 0.39269908169872414) {
                        int var1 = (int)Math.round(Math.sin(var4) * (double)i);
                        int var3 = (int)Math.round(Math.cos(var4) * (double)i);
                        BlockPos currentPos3 = new BlockPos((int)this.func_226277_ct_() + var1, (int)this.func_226278_cu_() - 1, (int)this.func_226281_cx_() + var3);
                        if (this.field_70170_p.func_180495_p(currentPos3).func_177230_c() != BlockRegistry.karosHeatTileGreen) continue;
                        this.field_70170_p.func_180501_a(currentPos3, BlockRegistry.karosHeatTileRed.func_176223_P(), 0);
                    }
                }
            }
        }
    }

    protected float func_70599_aP() {
        return 0.7f;
    }

    protected SoundEvent func_184639_G() {
        SoundEvent sound;
        String langKey;
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                langKey = "message.karos.laugh";
                sound = SoundRegistry.KAROS_LAUGH;
                break;
            }
            case 1: {
                langKey = "message.karos.doom";
                sound = SoundRegistry.MEET_DOOM;
                break;
            }
            case 2: {
                langKey = "message.karos.cmon";
                sound = SoundRegistry.TRY_YOUR_BEST;
                break;
            }
            default: {
                langKey = "message.karos.weak";
                sound = SoundRegistry.YOU_CANT_KILL_ME;
            }
        }
        this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0)).forEach(x -> x.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)x, langKey, new Object[0]), x.func_110124_au()));
        return sound;
    }

    public SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    public SoundEvent func_184615_bR() {
        return null;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.karosHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.karosDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.karosSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.karosFollowRange);
    }
}

