/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityLadyLunaSparkler;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.EntityStats;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class EntityLadyLuna
extends EntityDivineBoss {
    public ProtectionType protectionType;
    private int protectionTimer;
    private List<BlockPos> acidPositions = new ArrayList<BlockPos>();

    public EntityLadyLuna(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.setRandomProtectionValues();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 1.0f, 1.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PiglinEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            for (int x = (int)this.func_226277_ct_() - 2; x < (int)this.func_226277_ct_() + 2; ++x) {
                for (int y = (int)this.func_174813_aQ().field_72338_b; y < (int)this.func_174813_aQ().field_72338_b + 4; ++y) {
                    for (int z = (int)this.func_226281_cx_() - 2; z < (int)this.func_226281_cx_() + 2; ++z) {
                        if (this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_185904_a() != Material.field_151584_j && this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_185904_a() != Material.field_151575_d) continue;
                        this.field_70170_p.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 1);
                    }
                }
            }
        }
        BlockPos current = new BlockPos((int)this.func_226277_ct_() - 1, (int)this.func_226278_cu_(), (int)this.func_226281_cx_() - 1);
        BlockPos below = new BlockPos((int)this.func_226277_ct_() - 1, (int)this.func_226278_cu_() - 1, (int)this.func_226281_cx_() - 1);
        BlockState belowState = this.field_70170_p.func_180495_p(below);
        if (this.field_70170_p.func_180495_p(current).func_177230_c() == Blocks.field_150350_a && belowState.func_200132_m() && belowState.func_215704_f()) {
            this.field_70170_p.func_180501_a(current, BlockRegistry.lunicAcid.func_176223_P(), 1);
            this.acidPositions.add(current);
        }
        if (!this.field_70170_p.field_72995_K && this.getProtectionType() == ProtectionType.ARCANA && this.field_70173_aa % 30 == 0) {
            Iterator<BlockPos> iter = this.acidPositions.iterator();
            while (iter.hasNext()) {
                BlockPos pos = iter.next();
                if (this.field_70170_p.func_180495_p(pos).func_177230_c() != BlockRegistry.lunicAcid) {
                    iter.remove();
                    continue;
                }
                if (this.field_70146_Z.nextInt(4) != 0) continue;
                EntityLadyLunaSparkler e = new EntityLadyLunaSparkler(EntityRegistry.LADY_LUNA_SPARKLER, this.field_70170_p, (LivingEntity)this);
                e.func_225653_b_((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 0, (double)pos.func_177952_p() + 0.5);
                this.field_70170_p.func_217376_c((Entity)e);
            }
        }
        if (this.getProtectionTimer() <= 0) {
            this.setRandomProtectionValues();
        } else if (this.getProtectionTimer() > 0) {
            this.setProtectionTimer(this.getProtectionTimer() - 1);
        }
    }

    public void setProtectionType(ProtectionType type) {
        if (type == ProtectionType.ARCANA) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
        } else {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.32);
        }
        this.protectionType = type;
    }

    public void setProtectionTimer(int i) {
        this.protectionTimer = i;
    }

    public ProtectionType getProtectionType() {
        return this.protectionType;
    }

    public int getProtectionTimer() {
        return this.protectionTimer;
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (source.func_94541_c()) {
            return false;
        }
        ProtectionType type = this.getProtectionType();
        if (source.func_82725_o() && type == ProtectionType.ARCANA) {
            return false;
        }
        if ((source.func_76352_a() || source.func_76355_l().equals("thrown")) && type == ProtectionType.RANGED) {
            return false;
        }
        if (!source.func_76352_a() && !source.func_82725_o() && type == ProtectionType.MELEE) {
            return false;
        }
        return super.func_70097_a(source, par2);
    }

    public boolean func_70652_k(Entity e) {
        int dam = 20;
        boolean var4 = e.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)dam);
        if (var4) {
            this.field_70170_p.func_217385_a((Entity)this, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), 2.0f, Explosion.Mode.DESTROY);
            this.field_70169_q *= 0.6;
            this.field_70166_s *= 0.6;
            int var5 = EnchantmentHelper.func_90036_a((LivingEntity)this);
            if (var5 > 0) {
                e.func_70015_d(var5 * 4);
            }
        }
        return var4;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("Immunity", this.getProtectionType().value());
        tag.func_74768_a("ImmunityCooldown", this.getProtectionTimer());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setProtectionType(EntityLadyLuna.protectionTypeForInt(tag.func_74762_e("Immunity")));
        this.setProtectionTimer(tag.func_74762_e("ImmunityCooldown"));
    }

    private static ProtectionType protectionTypeForInt(int i) {
        switch (i) {
            case 0: {
                return ProtectionType.ARCANA;
            }
            case 1: {
                return ProtectionType.RANGED;
            }
            case 2: {
                return ProtectionType.MELEE;
            }
        }
        return null;
    }

    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    private void setRandomProtectionValues() {
        this.setProtectionType(EntityLadyLuna.protectionTypeForInt(this.field_70146_Z.nextInt(3)));
        this.setProtectionTimer(200 + this.field_70146_Z.nextInt(200));
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.ladyLunaHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.ladyLunaDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.ladyLunaSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.ladyLunaFollowRange);
    }

    public static enum ProtectionType {
        ARCANA(0),
        RANGED(1),
        MELEE(2);

        private int numVal;

        private ProtectionType(int numVal) {
            this.numVal = numVal;
        }

        public int value() {
            return this.numVal;
        }
    }
}

