/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityDivineArrow;
import divinerpg.enums.ArrowType;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityQuadro
extends EntityDivineBoss
implements IRangedAttackMob {
    private QuadroAbility ability = this.getRandomAbility();
    private int abilityCooldown;
    private int rangedAttackCounter;
    public boolean dir;

    public EntityQuadro(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(8, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 1.0f, 1.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PiglinEntity.class}));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az() instanceof LivingEntity) {
            this.func_82196_d(this.func_70638_az(), 0.0f);
        }
        if (this.abilityCooldown <= 0) {
            this.ability = this.getRandomAbility();
            this.abilityCooldown = 500;
            this.rangedAttackCounter = 0;
            this.dir = true;
            int s = this.field_70146_Z.nextInt(9);
            List players = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
            for (PlayerEntity p : players) {
                String chatMessage;
                SoundEvent sound;
                switch (s) {
                    case 0: {
                        sound = SoundRegistry.QUADRO_DIE_BEFORE;
                        chatMessage = "message.quadro.die";
                        break;
                    }
                    case 1: {
                        sound = SoundRegistry.QUADRO_ENOUGH;
                        chatMessage = "message.quadro.enough";
                        break;
                    }
                    case 2: {
                        sound = SoundRegistry.QUADRO_INCOMING_PUNCH;
                        chatMessage = "message.quadro.punch";
                        break;
                    }
                    case 3: {
                        sound = SoundRegistry.QUADRO_IS_NEXT;
                        chatMessage = "message.quadro.next";
                        break;
                    }
                    case 4: {
                        sound = SoundRegistry.QUADRO_KILL_MINE;
                        chatMessage = "message.quadro.mine";
                        break;
                    }
                    case 5: {
                        sound = SoundRegistry.QUADRO_MY_KILL;
                        chatMessage = "message.quadro.kill";
                        break;
                    }
                    case 6: {
                        sound = SoundRegistry.QUADRO_NO_DIE;
                        chatMessage = "message.quadro.no";
                        break;
                    }
                    case 7: {
                        sound = SoundRegistry.QUADRO_SIT_DOWN;
                        chatMessage = "message.quadro.sit";
                        break;
                    }
                    default: {
                        sound = SoundRegistry.QUADRO_TASTE_FIST;
                        chatMessage = "message.quadro.taste";
                    }
                }
                this.field_70170_p.func_184133_a(p, p.func_233580_cy_(), sound, SoundCategory.HOSTILE, 1.0f, 1.0f);
                if (this.field_70170_p.field_72995_K) continue;
                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)p, chatMessage, new Object[0]), p.func_110124_au());
            }
        }
        if (this.abilityCooldown == 480) {
            --this.abilityCooldown;
            this.dir = false;
        }
        if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == QuadroAbility.MELEE_SLOW) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.32);
            this.func_70659_e(0.48f);
        } else if (this.ability == QuadroAbility.MELEE_FAST) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.48);
            this.func_70659_e(0.32f);
        } else if (this.ability == QuadroAbility.RANGED_SLOW) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
            this.func_70659_e(0.0f);
        } else if (this.ability == QuadroAbility.RANGED_FAST) {
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
            this.func_70659_e(0.0f);
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.func_70089_S()) {
            switch (this.ability) {
                case RANGED_FAST: {
                    if (this.rangedAttackCounter % 5 == 0 && this.func_70638_az() != null) {
                        EntityDivineArrow projectile = new EntityDivineArrow(EntityRegistry.ARROW_SHOT, this.field_70170_p, ArrowType.KAROS_ARROW, (LivingEntity)this, target, 1.6f, 12.0f);
                        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
                        double d1 = target.func_226283_e_(0.3333333333333333) - projectile.func_226278_cu_();
                        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
                        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                        projectile.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
                        this.field_70170_p.func_217376_c((Entity)projectile);
                    }
                    ++this.rangedAttackCounter;
                    break;
                }
                case RANGED_SLOW: {
                    if (this.rangedAttackCounter % 15 == 0 && this.func_70638_az() != null) {
                        EntityDivineArrow projectile = new EntityDivineArrow(EntityRegistry.ARROW_SHOT, this.field_70170_p, ArrowType.KAROS_ARROW, (LivingEntity)this, target, 1.6f, 12.0f);
                        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
                        double d1 = target.func_226283_e_(0.3333333333333333) - projectile.func_226278_cu_();
                        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
                        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                        projectile.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
                        this.field_70170_p.func_217376_c((Entity)projectile);
                    }
                    ++this.rangedAttackCounter;
                    break;
                }
            }
        }
    }

    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    private QuadroAbility getRandomAbility() {
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                return QuadroAbility.RANGED_SLOW;
            }
            case 1: {
                return QuadroAbility.RANGED_FAST;
            }
            case 2: {
                return QuadroAbility.MELEE_SLOW;
            }
            case 3: {
                return QuadroAbility.MELEE_FAST;
            }
        }
        return null;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.quadroHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.quadroAttack).func_233815_a_(Attributes.field_233821_d_, EntityStats.quadroSpeedSlow).func_233815_a_(Attributes.field_233819_b_, EntityStats.quadroFollowRange);
    }

    static enum QuadroAbility {
        RANGED_SLOW(0),
        RANGED_FAST(1),
        MELEE_SLOW(2),
        MELEE_FAST(3);

        private int numVal;

        private QuadroAbility(int numVal) {
            this.numVal = numVal;
        }

        public int value() {
            return this.numVal;
        }
    }
}

