/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityRaglokBomb;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityRaglok
extends EntityDivineBoss {
    private int ability;
    private final int DEFAULT = 0;
    private final int LIGHTNING = 1;
    private final int BLIND = 2;
    private final int BOMBS = 3;
    private final int SLOW = 4;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int abilityCooldown;
    private boolean loaded = false;
    private int rangedAttackCounter;
    private boolean avengeAbilityUsed = false;

    public EntityRaglok(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.loaded && !this.field_70170_p.field_72995_K) {
            List players = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
            for (PlayerEntity p : players) {
                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)p, "message.raglok.dare", new Object[0]), p.func_110124_au());
            }
            this.func_184185_a(SoundRegistry.RAGLOK_AWAKEN, 1.0f, 1.0f);
            this.loaded = true;
        }
        this.manageAbilities();
    }

    public void manageAbilities() {
        PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, 64.0);
        if (player == null || player.func_184812_l_() || this.avengeAbilityUsed) {
            return;
        }
        if (this.abilityCooldown == 0 || this.ability == 0) {
            this.abilityCooldown = 400;
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    this.ability = 1;
                    this.rangedAttackCounter = 0;
                    this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.0);
                    break;
                }
                case 1: {
                    this.ability = 2;
                    this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.3);
                    break;
                }
                case 2: {
                    this.ability = 3;
                    this.rangedAttackCounter = 0;
                    this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.3);
                    break;
                }
                case 3: {
                    this.ability = 4;
                    this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.3);
                    break;
                }
            }
            this.message();
        } else if (this.abilityCooldown > 0) {
            --this.abilityCooldown;
        }
        if (this.ability == 2 && player != null) {
            player.func_195064_c(new EffectInstance(Effects.field_76440_q, 25, 0));
        }
        if (this.ability == 4 && player != null) {
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, 1));
        }
        if (this.ability == 1) {
            if (this.abilityCooldown % 40 == 0 && player != null) {
                LightningBoltEntity ent = new LightningBoltEntity(EntityType.field_200728_aG, this.field_70170_p);
                ent.func_70107_b(this.prevPlayerX, this.prevPlayerY, this.prevPlayerZ);
                this.field_70170_p.func_217376_c((Entity)ent);
                ++this.rangedAttackCounter;
            } else if (this.abilityCooldown % 40 != 0 && this.abilityCooldown % 20 == 0 && player != null) {
                this.prevPlayerX = player.func_226277_ct_();
                this.prevPlayerY = player.func_226278_cu_();
                this.prevPlayerZ = player.func_226281_cx_();
            }
            if (this.rangedAttackCounter == 10) {
                this.ability = 0;
            }
        }
        if (this.ability == 3) {
            if (this.abilityCooldown % 30 == 0 && player != null && this.func_70089_S()) {
                for (int i = 0; i < 4; ++i) {
                    EntityRaglokBomb var2 = new EntityRaglokBomb(EntityRegistry.RAGLOK_BOMB, this.field_70170_p);
                    var2.func_225653_b_(player.field_70169_q, player.field_70167_r + 5.0, player.field_70166_s);
                    var2.func_213293_j((this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 5.0, -0.14, (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 5.0);
                    this.field_70170_p.func_217376_c((Entity)var2);
                    ++this.rangedAttackCounter;
                }
            }
            if (this.rangedAttackCounter == 12) {
                this.ability = 0;
            }
        }
    }

    private void message() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(64.0, 64.0, 64.0));
        block6: for (int var1 = 0; var1 < list.size(); ++var1) {
            if (!(list.get(var1) instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)list.get(var1);
            switch (this.ability) {
                case 1: {
                    this.func_184185_a(SoundRegistry.RAGLOK_GUARDIAN, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.raglok.think", new Object[0]), player.func_110124_au());
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.raglok.great", new Object[0]), player.func_110124_au());
                    continue block6;
                }
                case 2: {
                    this.func_184185_a(SoundRegistry.RAGLOK_DARK, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.raglok.future", new Object[0]), player.func_110124_au());
                    continue block6;
                }
                case 3: {
                    this.func_184185_a(SoundRegistry.RAGLOK_RAIN, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.raglok.rain", new Object[0]), player.func_110124_au());
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.raglok.kill", new Object[0]), player.func_110124_au());
                    continue block6;
                }
                case 4: {
                    this.func_184185_a(SoundRegistry.RAGLOK_NOTHING, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block6;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.raglok.compare", new Object[0]), player.func_110124_au());
                    continue block6;
                }
            }
        }
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(8, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 1.0f, 1.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PiglinEntity.class}));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.RAGLOK_AVENGE;
    }

    public void func_70645_a(DamageSource source) {
        if (!this.avengeAbilityUsed) {
            PlayerEntity player;
            if (!this.field_70170_p.field_72995_K) {
                List players = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
                for (PlayerEntity p : players) {
                    p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)p, "message.raglok.avenge", new Object[0]), p.func_110124_au());
                }
            }
            if ((player = this.field_70170_p.func_217362_a((Entity)this, 64.0)) != null && !player.func_184812_l_()) {
                LightningBoltEntity bolt = new LightningBoltEntity(EntityType.field_200728_aG, this.field_70170_p);
                bolt.func_70107_b(player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c);
                this.field_70170_p.func_217376_c((Entity)bolt);
            }
            this.avengeAbilityUsed = true;
        }
        super.func_70645_a(source);
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.raglokHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.raglokDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.raglokSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.raglokFollowRange);
    }
}

