/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineFlyingMob;
import divinerpg.entities.projectile.EntityWatcherShot;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityTheWatcher
extends EntityDivineFlyingMob {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityTheWatcher.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int explosionStrength = 1;

    public EntityTheWatcher(EntityType<? extends FlyingEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 5000;
        this.field_70765_h = new MoveHelperController(this);
    }

    public boolean func_230279_az_() {
        return true;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.theWatcherHealth).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233821_d_, EntityStats.theWatcherSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.theWatcherFollowRange).func_233815_a_(Attributes.field_233822_e_, EntityStats.theWatcherSpeed);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.6f;
    }

    public boolean canSpawn(IWorld worldIn, SpawnReason spawnReasonIn) {
        return this.field_70170_p.func_234923_W_() == World.field_234918_g_;
    }

    @Override
    protected void func_184651_r() {
        this.addAttackingAI();
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new FireballAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, p_213812_1_ -> Math.abs(p_213812_1_.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    protected boolean isDespawnPeaceful() {
        return true;
    }

    @Override
    public void func_82196_d(LivingEntity entity, float range) {
        super.func_82196_d(entity, range);
        if (this.func_70089_S()) {
            EntityWatcherShot projectile = new EntityWatcherShot(EntityRegistry.WATCHER_SHOT, this.field_70170_p, (LivingEntity)this);
            double d0 = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
            double d1 = this.func_70638_az().func_226283_e_(0.3333333333333333) - projectile.func_226278_cu_();
            double d2 = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            projectile.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
            this.field_70170_p.func_217376_c((Entity)projectile);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76346_g() instanceof FireballEntity && source.func_76364_f() instanceof PlayerEntity) {
            super.func_70097_a(source, 1000.0f);
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.ROAR;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.ROAR;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.ROAR;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = compound.func_74762_e("ExplosionPower");
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityTheWatcher mob;

        public RandomFlyGoal(EntityTheWatcher entity) {
            this.mob = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.mob.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.mob.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.mob.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.mob.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.mob.func_70681_au();
            double d0 = this.mob.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.mob.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.mob.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.mob.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityTheWatcher mob;
        private int floatDuration;

        public MoveHelperController(EntityTheWatcher ent) {
            super((MobEntity)ent);
            this.mob = ent;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.mob.func_70681_au().nextInt(5) + 2;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.mob.func_226277_ct_(), this.field_75647_c - this.mob.func_226278_cu_(), this.field_75644_d - this.mob.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (this.canReach(vector3d = vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.mob.func_213317_d(this.mob.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean canReach(Vector3d vec, int ticks) {
            AxisAlignedBB axisalignedbb = this.mob.func_174813_aQ();
            for (int i = 1; i < ticks; ++i) {
                if (this.mob.field_70170_p.func_226665_a__((Entity)this.mob, axisalignedbb = axisalignedbb.func_191194_a(vec))) continue;
                return false;
            }
            return true;
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final EntityTheWatcher mob;

        public LookAroundGoal(EntityTheWatcher ent) {
            this.mob = ent;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.mob.func_70638_az() == null) {
                Vector3d vector3d = this.mob.func_213322_ci();
                this.mob.field_70761_aq = this.mob.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.mob.func_70638_az();
                if (livingentity.func_70068_e((Entity)this.mob) < 4096.0) {
                    double d1 = livingentity.func_226277_ct_() - this.mob.func_226277_ct_();
                    double d2 = livingentity.func_226281_cx_() - this.mob.func_226281_cx_();
                    this.mob.field_70761_aq = this.mob.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class FireballAttackGoal
    extends Goal {
        private final EntityTheWatcher mob;
        public int chargeTime;

        public FireballAttackGoal(EntityTheWatcher ent) {
            this.mob = ent;
        }

        public boolean func_75250_a() {
            return this.mob.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.chargeTime = 0;
        }

        public void func_75251_c() {
            this.mob.setAttacking(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.mob.func_70638_az();
            if (livingentity.func_70068_e((Entity)this.mob) < 4096.0 && this.mob.func_70685_l((Entity)livingentity)) {
                World world = this.mob.field_70170_p;
                ++this.chargeTime;
                if (this.chargeTime == 10 && !this.mob.func_174814_R()) {
                    world.func_217378_a(null, 1015, this.mob.func_233580_cy_(), 0);
                }
                if (this.chargeTime == 20) {
                    Vector3d vector3d = this.mob.func_70676_i(1.0f);
                    double d2 = livingentity.func_226277_ct_() - (this.mob.func_226277_ct_() + vector3d.field_72450_a * 4.0);
                    double d3 = livingentity.func_226283_e_(0.5) - (0.5 + this.mob.func_226283_e_(0.5));
                    double d4 = livingentity.func_226281_cx_() - (this.mob.func_226281_cx_() + vector3d.field_72449_c * 4.0);
                    if (!this.mob.func_174814_R()) {
                        world.func_217378_a(null, 1016, this.mob.func_233580_cy_(), 0);
                    }
                    EntityWatcherShot shot = new EntityWatcherShot(EntityRegistry.WATCHER_SHOT, world, (LivingEntity)this.mob);
                    shot.func_70186_c(d2, d3, d4, 1.0f, 1.0f);
                    shot.func_70107_b(this.mob.func_226277_ct_() + vector3d.field_72450_a * 4.0, this.mob.func_226283_e_(0.5) + 0.5, shot.func_226281_cx_() + vector3d.field_72449_c * 4.0);
                    world.func_217376_c((Entity)shot);
                    this.chargeTime = -40;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.mob.setAttacking(this.chargeTime > 10);
        }
    }
}

