/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.EntityWreckBouncingProjectile;
import divinerpg.entities.projectile.EntityWreckExplosiveShot;
import divinerpg.entities.projectile.EntityWreckShot;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.command.ICommandSource;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityWreck
extends EntityDivineBoss {
    private final int MELEE = 0;
    private final int ARCANA = 1;
    private final int RANGED = 2;
    private final int DEFAULT = 0;
    private final int CHARGE = 1;
    private final int PULL = 2;
    private final int FIRE = 3;
    private final int BOUNCE = 4;
    private final int FREEZE = 5;
    private final int SPEED = 6;
    private final int EXPLOSIONS = 7;
    private final int STRENGTH = 8;
    private int abilityTimer;
    private boolean dead = false;
    private boolean loaded = false;
    private int ability;
    private int abilityType;

    public EntityWreck(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void manageAbilities() {
        PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, 64.0);
        if (this.func_110143_aJ() < 341.0f) {
            this.setAbilityType(2);
        } else if (this.func_110143_aJ() < 682.0f && this.func_110143_aJ() > 341.0f) {
            this.setAbilityType(1);
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.1);
            this.func_70659_e((float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e());
        } else {
            this.setAbilityType(0);
        }
        if (this.abilityTimer > 0) {
            --this.abilityTimer;
        }
        if (this.getAbilityType() == 1 && (this.getAbility() == 1 || this.getAbility() == 2) || this.getAbilityType() == 2 && (this.getAbility() == 3 || this.getAbility() == 4 || this.getAbility() == 5)) {
            this.setAbility(0);
        }
        if (this.getAbility() == 0 && this.abilityTimer == 0) {
            this.abilityTimer = 200;
            block0 : switch (this.getAbilityType()) {
                case 0: {
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            this.setAbility(2);
                            this.func_70659_e(0.0f);
                            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.32);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(1);
                            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.5);
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.field_70146_Z.nextInt(3)) {
                        case 0: {
                            this.setAbility(3);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(4);
                            break block0;
                        }
                        case 2: {
                            this.setAbility(5);
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.field_70146_Z.nextInt(3)) {
                        case 0: {
                            this.setAbility(6);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(7);
                            break block0;
                        }
                        case 2: {
                            this.setAbility(8);
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.message();
        }
        if (this.getAbility() == 1 && this.abilityTimer == 0) {
            this.setAbility(0);
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.32);
        }
        if (this.getAbility() == 3 && player != null) {
            for (int i = 1; i < 20; ++i) {
                int var2 = (this.func_233580_cy_().func_177958_n() - player.func_233580_cy_().func_177958_n()) * i / 5;
                int var3 = (this.func_233580_cy_().func_177952_p() - player.func_233580_cy_().func_177952_p()) * i / 5;
                if (this.field_70170_p.func_180495_p(new BlockPos(this.func_233580_cy_().func_177958_n() - var2, this.func_233580_cy_().func_177956_o(), this.func_233580_cy_().func_177952_p() - var3)) != Blocks.field_150350_a.func_176223_P()) continue;
                this.field_70170_p.func_180501_a(new BlockPos(this.func_233580_cy_().func_177958_n() - var2, this.func_233580_cy_().func_177956_o(), this.func_233580_cy_().func_177952_p() - var3), Blocks.field_150480_ab.func_176223_P(), 0);
            }
            this.setAbility(0);
        }
        if (this.getAbility() == 5 && player != null) {
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 5));
            this.setAbility(0);
            this.abilityTimer = 100;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.performRangedAttack((LivingEntity)player);
        }
    }

    private void message() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(64.0, 64.0, 64.0));
        block9: for (int var1 = 0; var1 < list.size(); ++var1) {
            if (!(list.get(var1) instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)list.get(var1);
            switch (this.getAbility()) {
                case 1: {
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.wreck.charge", new Object[0]), player.func_110124_au());
                    continue block9;
                }
                case 2: {
                    this.func_184185_a(SoundRegistry.FEEL_SOUL_ARKSIANE, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.wreck.pull", new Object[0]), player.func_110124_au());
                    continue block9;
                }
                case 3: {
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.wreck.fire", new Object[0]), player.func_110124_au());
                    continue block9;
                }
                case 5: {
                    this.func_184185_a(SoundRegistry.STOP_AT_ONCE, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.wreck.freeze", new Object[0]), player.func_110124_au());
                    continue block9;
                }
                case 6: {
                    this.func_184185_a(SoundRegistry.WRECK_SPEED, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.wreck.speed", new Object[0]), player.func_110124_au());
                    continue block9;
                }
                case 7: {
                    this.func_184185_a(SoundRegistry.EXPLOSIONS, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.wreck.explosion", new Object[0]), player.func_110124_au());
                    continue block9;
                }
                case 8: {
                    this.func_184185_a(SoundRegistry.WRECK_STRENGTH, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "message.wreck.strength", new Object[0]), player.func_110124_au());
                    continue block9;
                }
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.loaded) {
            List players = this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
            for (PlayerEntity p : players) {
                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)p, "message.wreck.run", new Object[0]), p.func_110124_au());
                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)p, "message.wreck.smell", new Object[0]), p.func_110124_au());
            }
            this.func_184185_a(SoundRegistry.WRECK_INTRO, 1.0f, 1.0f);
            this.loaded = true;
        }
        if (this.dead) {
            return;
        }
        PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, 64.0);
        if (this.getAbility() == 2 && player != null && !player.func_184812_l_()) {
            player.func_213293_j((this.func_226277_ct_() - player.func_226277_ct_()) * 0.069, (this.func_226278_cu_() - player.func_226278_cu_()) * 0.069, (this.func_226281_cx_() - player.func_226281_cx_()) * 0.069);
        }
        this.manageAbilities();
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (this.getAbilityType() != 0) {
            return false;
        }
        float amount = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        int knockback = 0;
        boolean var4 = par1Entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), amount);
        if (var4) {
            int var5;
            if (this.getAbility() == 2) {
                this.setAbility(1);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.5);
                knockback = 2;
            }
            if (knockback > 0) {
                par1Entity.func_213293_j((double)(-MathHelper.func_76126_a((float)(this.field_70125_A * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.func_213293_j(this.func_213322_ci().field_72450_a * 0.6, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c * 0.6);
            }
            if ((var5 = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
                par1Entity.func_70015_d(var5 * 4);
            }
        }
        return var4;
    }

    public void performRangedAttack(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        if (this.func_70089_S()) {
            double tx = entity.func_226277_ct_() - this.func_226277_ct_();
            double ty = entity.func_226283_e_(0.3333333333333333);
            double tz = entity.func_226281_cx_() - this.func_226281_cx_();
            switch (this.getAbility()) {
                case 4: {
                    EntityWreckBouncingProjectile projectile = new EntityWreckBouncingProjectile(EntityRegistry.WRECK_BOUNCING_PROJECTILE, this.field_70170_p, (LivingEntity)this, 35);
                    projectile.func_70186_c(tx, ty, tz, 1.6f, 12.0f);
                    this.field_70170_p.func_217376_c((Entity)projectile);
                    this.setAbility(0);
                    break;
                }
                case 6: {
                    if (this.abilityTimer % 5 == 0) {
                        EntityWreckShot shot = new EntityWreckShot(EntityRegistry.WRECK_SHOT, this.field_70170_p, (LivingEntity)this, 15);
                        shot.func_70186_c(tx, ty, tz, 1.6f, 12.0f);
                        this.field_70170_p.func_217376_c((Entity)shot);
                    }
                    if (this.abilityTimer > 100) break;
                    this.setAbility(0);
                    break;
                }
                case 7: {
                    if (this.abilityTimer % 40 == 0) {
                        EntityWreckExplosiveShot shot = new EntityWreckExplosiveShot(EntityRegistry.WRECK_EXPLOSIVE_SHOT, (LivingEntity)this, this.field_70170_p);
                        shot.func_70186_c(tx, ty, tz, 1.6f, 12.0f);
                        this.field_70170_p.func_217376_c((Entity)shot);
                    }
                    if (this.abilityTimer != 0) break;
                    this.setAbility(0);
                    break;
                }
                case 8: {
                    if (this.abilityTimer % 40 == 0) {
                        EntityWreckShot shot = new EntityWreckShot(EntityRegistry.WRECK_SHOT, this.field_70170_p, (LivingEntity)this, 40);
                        shot.func_70186_c(tx, ty, tz, 1.6f, 12.0f);
                        this.field_70170_p.func_217376_c((Entity)shot);
                    }
                    if (this.abilityTimer != 0) break;
                    this.setAbility(0);
                    break;
                }
            }
        }
    }

    public int getAbilityType() {
        return this.abilityType;
    }

    public void setAbilityType(int type) {
        this.abilityType = type;
    }

    public int getAbility() {
        return this.ability;
    }

    public void setAbility(int ability) {
        this.ability = ability;
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(8, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(8, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 1.0f, 1.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PiglinEntity.class}));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public int func_70641_bl() {
        return 3;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.wreckHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.wreckDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.wreckSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.wreckFollowRange);
    }
}

