/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss.ayeraco;

import divinerpg.entities.boss.ayeraco.EntityAyeraco;
import divinerpg.entities.boss.ayeraco.EntityAyeracoBlue;
import divinerpg.entities.boss.ayeraco.EntityAyeracoGreen;
import divinerpg.entities.boss.ayeraco.EntityAyeracoPurple;
import divinerpg.entities.boss.ayeraco.EntityAyeracoRed;
import divinerpg.entities.boss.ayeraco.EntityAyeracoYellow;
import divinerpg.entities.boss.ayeraco.EntityFinder;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;

public class AyeracoGroup
implements INBTSerializable<CompoundNBT> {
    private EntityFinder<EntityAyeracoRed> red;
    private EntityFinder<EntityAyeracoGreen> green;
    private EntityFinder<EntityAyeracoBlue> blue;
    private EntityFinder<EntityAyeracoPurple> purple;
    private EntityFinder<EntityAyeracoYellow> yellow;

    public AyeracoGroup(ServerWorld world) {
        this(world, null, null, null, null, null);
    }

    public AyeracoGroup(ServerWorld world, UUID red, UUID green, UUID blue, UUID yellow, UUID purple) {
        this.red = new EntityFinder<EntityAyeracoRed>(EntityAyeracoRed.class, world, red);
        this.green = new EntityFinder<EntityAyeracoGreen>(EntityAyeracoGreen.class, world, green);
        this.blue = new EntityFinder<EntityAyeracoBlue>(EntityAyeracoBlue.class, world, blue);
        this.purple = new EntityFinder<EntityAyeracoPurple>(EntityAyeracoPurple.class, world, purple);
        this.yellow = new EntityFinder<EntityAyeracoYellow>(EntityAyeracoYellow.class, world, yellow);
    }

    public AyeracoGroup(List<EntityAyeraco> ayeracos) {
        this((ServerWorld)ayeracos.get((int)0).field_70170_p, ayeracos.get(0).func_110124_au(), ayeracos.get(1).func_110124_au(), ayeracos.get(2).func_110124_au(), ayeracos.get(3).func_110124_au(), ayeracos.get(4).func_110124_au());
    }

    public boolean canTeleport(LivingEntity ayeraco) {
        EntityAyeraco superAyeraco = this.purple.get();
        return superAyeraco == ayeraco || this.isHealthy((LivingEntity)superAyeraco);
    }

    public boolean projectileProtected(LivingEntity ayeraco) {
        EntityAyeraco superAyeraco = this.green.get();
        return superAyeraco == ayeraco || this.isHealthy((LivingEntity)superAyeraco);
    }

    public void tick(EntityAyeraco ayeraco) {
        EffectInstance effect;
        if (!this.isAngry((LivingEntity)ayeraco)) {
            return;
        }
        List<EntityAyeraco> livingAyeracos = Stream.of(this.red, this.green, this.blue, this.purple, this.yellow).map(EntityFinder::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (!livingAyeracos.contains((Object)ayeraco)) {
            return;
        }
        if (this.yellow.sameEntity((Entity)ayeraco)) {
            effect = new EffectInstance(Effects.field_76424_c, 1, 1);
            livingAyeracos.forEach(x -> x.func_195064_c(effect));
        }
        if (this.red.sameEntity((Entity)ayeraco)) {
            livingAyeracos.forEach(x -> x.func_70691_i(0.3f));
        }
        if (this.blue.sameEntity((Entity)ayeraco) && this.isAngry((LivingEntity)ayeraco)) {
            effect = new EffectInstance(Effects.field_76420_g, 1, 2);
            livingAyeracos.forEach(x -> x.func_195064_c(effect));
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("red", (INBT)this.red.serializeNBT());
        compound.func_218657_a("green", (INBT)this.green.serializeNBT());
        compound.func_218657_a("blue", (INBT)this.blue.serializeNBT());
        compound.func_218657_a("purple", (INBT)this.purple.serializeNBT());
        compound.func_218657_a("yellow", (INBT)this.yellow.serializeNBT());
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.red.deserializeNBT(nbt.func_74775_l("red"));
        this.green.deserializeNBT(nbt.func_74775_l("green"));
        this.blue.deserializeNBT(nbt.func_74775_l("blue"));
        this.purple.deserializeNBT(nbt.func_74775_l("purple"));
        this.yellow.deserializeNBT(nbt.func_74775_l("yellow"));
    }

    private boolean isHealthy(LivingEntity e) {
        return this.checkNotDead((Entity)e) && e.func_110143_aJ() / e.func_110138_aP() > 0.5f;
    }

    private boolean isAngry(LivingEntity e) {
        return this.checkNotDead((Entity)e) && e.func_110143_aJ() / e.func_110138_aP() <= 0.5f;
    }

    private boolean checkNotDead(Entity e) {
        return e != null && e.func_70089_S();
    }
}

