/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss.ayeraco;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.boss.ayeraco.AyeracoGroup;
import divinerpg.entities.projectile.EntityEnderTripletsFireball;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityAyeraco
extends EntityDivineBoss {
    private int waitTick;
    private BlockPos currentFlightTarget;
    private boolean attacks;
    private double moveX;
    private double moveZ;
    private boolean halfHp;
    public float moveSpeed = 0.3f;
    private BlockPos beamLocation;
    private AyeracoGroup group;

    public EntityAyeraco(EntityType<? extends Entity> type, World worldIn) {
        this(type, worldIn, new BlockPos(0, 100, 0));
    }

    public EntityAyeraco(EntityType<? extends Entity> type, World world, BlockPos beam) {
        super(type, world);
        this.beamLocation = beam;
        this.waitTick = 0;
        this.attacks = false;
        this.halfHp = false;
        this.moveX = this.field_70146_Z.nextGaussian() * 0.25 - 0.125;
        this.moveZ = this.field_70146_Z.nextGaussian() * 0.25 - 0.125;
        this.func_70012_b(beam.func_177958_n(), beam.func_177956_o() + 4, beam.func_177952_p(), this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
        ServerWorld serverWorld = world instanceof ServerWorld ? (ServerWorld)world : null;
        this.group = new AyeracoGroup(serverWorld);
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.ayeracoHealth).func_233815_a_(Attributes.field_233821_d_, EntityStats.ayeracoSpeed).func_233815_a_(Attributes.field_233823_f_, EntityStats.ayeracoDamage).func_233815_a_(Attributes.field_233819_b_, EntityStats.ayeracoFollowRange);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.addAttackingAI();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b * (double)0.6f, this.func_213322_ci().field_72449_c);
    }

    public void func_70619_bc() {
        PlayerEntity attackablePlayer;
        super.func_70619_bc();
        this.group.tick(this);
        if (this.func_110143_aJ() * 2.0f < this.func_110138_aP() && !this.halfHp) {
            this.func_184185_a(SoundRegistry.AYERACO_HALF_HEALTH, 20.0f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.halfHp = true;
        }
        if ((attackablePlayer = this.field_70170_p.func_217362_a((Entity)this, 128.0)) != null) {
            this.func_70624_b((LivingEntity)attackablePlayer);
        }
        if (this.waitTick == 0) {
            if (this.func_70638_az() != null) {
                int var1 = (int)this.func_70638_az().func_226277_ct_();
                int var2 = (int)this.func_70638_az().func_226278_cu_();
                int var3 = (int)this.func_70638_az().func_226281_cx_();
                this.currentFlightTarget = new BlockPos(var1, var2, var3);
            }
            this.func_213293_j(this.func_213322_ci().field_72450_a, 0.0, this.func_213322_ci().field_72449_c);
            if (this.currentFlightTarget != null) {
                double var1 = (double)this.currentFlightTarget.func_177958_n() - this.func_226277_ct_();
                double var3 = (double)this.currentFlightTarget.func_177956_o() - this.func_226278_cu_();
                double var5 = (double)this.currentFlightTarget.func_177952_p() - this.func_226281_cx_();
                if (Math.signum(var1) != 0.0 || Math.signum(var3) != 0.0 || Math.signum(var5) != 0.0) {
                    this.func_213293_j(Math.signum(var1) * (double)this.moveSpeed, this.func_213322_ci().field_72448_b + (Math.signum(var3) * 5.699999988079071 - this.func_213322_ci().field_72448_b) * (double)0.1f, Math.signum(var5) * (double)this.moveSpeed);
                    float var7 = (float)(Math.atan2(this.field_70166_s, this.field_70169_q) * 180.0 / Math.PI) - 90.0f;
                    float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
                    this.field_82151_R = 0.5f;
                    this.field_70177_z += var8;
                }
            }
        } else {
            --this.waitTick;
            this.func_213293_j(this.func_213322_ci().field_72450_a, 0.3, this.func_213322_ci().field_72449_c);
        }
        if (!this.attacks) {
            this.waitTick = 80;
            this.attacks = true;
            if (this.group.canTeleport((LivingEntity)this)) {
                this.waitTick = 0;
                this.teleportRandomUp();
            }
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    public boolean func_70097_a(DamageSource damageSource, float par2) {
        if (this.func_180431_b(damageSource) || damageSource.func_76364_f() instanceof EntityEnderTripletsFireball || damageSource.func_76352_a() && this.group.projectileProtected((LivingEntity)this)) {
            return false;
        }
        if (damageSource.func_76364_f() instanceof PlayerEntity) {
            this.attacks = true;
        }
        return super.func_70097_a(damageSource, par2);
    }

    public boolean func_70652_k(Entity entity) {
        this.attacks = false;
        return super.func_70652_k(entity);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.AYERACO;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.AYERACO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.AYERACO_HURT;
    }

    public boolean func_70039_c(CompoundNBT compound) {
        compound.func_218657_a("group", (INBT)this.group.serializeNBT());
        compound.func_74772_a("beamPos", this.beamLocation.func_218275_a());
        return super.func_70039_c(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.group.deserializeNBT(compound.func_74775_l("group"));
        this.beamLocation = BlockPos.func_218283_e((long)compound.func_74763_f("beamPos"));
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70170_p.func_195588_v(this.beamLocation)) {
            this.field_70170_p.func_180501_a(this.beamLocation, Blocks.field_150350_a.func_176223_P(), 0);
        }
    }

    public void initGroup(AyeracoGroup group) {
        this.group = group;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void teleportRandomUp() {
        this.func_184185_a(SoundRegistry.AYERACO_TELEPORT, 2.0f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70167_r = 20.0;
        this.field_70169_q = this.field_70146_Z.nextInt(5);
        this.field_70166_s = this.field_70146_Z.nextInt(5);
    }
}

