/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.eden;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.entities.mortum.EntityAngryBunny;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityBunny
extends EntityDivineTameable {
    private static final DataParameter<Boolean> TAMED_AND_ANGRY = EntityDataManager.func_187226_a(EntityBunny.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityBunny(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 40;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.5f;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.bunnyHealth).func_233815_a_(Attributes.field_233821_d_, EntityStats.bunnySpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.bunnyFollowRange);
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return true;
    }

    @Override
    public float func_205022_a(BlockPos p_205022_1_, IWorldReader p_205022_2_) {
        return 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED_AND_ANGRY, (Object)false);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (!this.field_70170_p.field_72995_K && !this.func_70909_n()) {
            this.transform();
        }
    }

    @Override
    public boolean func_70652_k(Entity target) {
        if (this.func_70909_n()) {
            this.field_70180_af.func_187227_b(TAMED_AND_ANGRY, (Object)true);
        }
        return super.func_70652_k(target);
    }

    public boolean isTamedAndAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED_AND_ANGRY);
    }

    @Nullable
    public LivingEntity func_70638_az() {
        LivingEntity entity = super.func_70638_az();
        if (entity != null && (this.func_70909_n() && this.func_70068_e((Entity)entity) < 144.0 || !this.func_70909_n())) {
            return entity;
        }
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70909_n() && this.func_70638_az() == null) {
            this.field_70180_af.func_187227_b(TAMED_AND_ANGRY, (Object)false);
        }
    }

    private void transform() {
        if (!this.field_70170_p.field_72995_K) {
            EntityAngryBunny e = new EntityAngryBunny(EntityRegistry.ANGRY_BUNNY, this.field_70170_p);
            e.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70125_A, this.field_70177_z);
            this.field_70170_p.func_217376_c((Entity)e);
            this.func_70106_y();
        }
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (held != null && held.func_222117_E()) {
                Item food = held.func_77973_b();
                if (food.func_219967_s().func_221467_c() && this.func_110143_aJ() < 20.0f) {
                    if (!player.func_184812_l_()) {
                        held.func_190918_g(1);
                    }
                    this.func_70691_i(food.func_219967_s().func_221466_a());
                    return ActionResultType.PASS;
                }
            } else if (this.func_152114_e((LivingEntity)player)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_233687_w_(!this.func_233685_eM_());
                    this.field_70703_bu = false;
                }
                return ActionResultType.PASS;
            }
        } else if (held != null && held.func_77973_b() == ItemRegistry.edenSparkles) {
            if (!player.func_184812_l_()) {
                held.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_193101_c(player);
                    this.func_70624_b(null);
                    this.func_233687_w_(true);
                    this.func_70606_j(20.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return ActionResultType.PASS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.BUNNY;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.BUNNY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.BUNNY_HURT;
    }
}

