/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.entities.projectile.DivineThrowable;
import divinerpg.enums.DiskType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;

public class EntityDisk
extends DivineThrowable {
    private static final DataParameter<Byte> DISK_ID = EntityDataManager.func_187226_a(EntityDisk.class, (IDataSerializer)DataSerializers.field_187191_a);
    private DiskType diskType;
    public float damage;
    public int counter;
    public int icon;
    public Item item;
    private int bounces;

    public EntityDisk(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
    }

    public EntityDisk(EntityType<? extends ThrowableEntity> type, World world, LivingEntity entity, DiskType diskType, Item item) {
        super(type, entity, world);
        this.diskType = diskType;
        this.setDiskId((byte)diskType.ordinal());
        this.damage = diskType.getDamage();
        this.counter = 30;
        this.item = item;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DISK_ID, (Object)0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213293_j(this.func_213322_ci().field_72450_a / 0.99, this.func_213322_ci().field_72448_b / 0.99, this.func_213322_ci().field_72449_c / 0.99);
        if (this.counter == 0 && this.func_234616_v_() != null) {
            this.func_213293_j(this.func_213322_ci().field_72450_a * -1.0, this.func_213322_ci().field_72448_b * -1.0, this.func_213322_ci().field_72449_c * -1.0);
            ++this.bounces;
            this.counter = 30;
        } else if (this.counter > 0) {
            --this.counter;
        }
        if (this.bounces >= 12 && !this.field_70170_p.field_72995_K) {
            this.func_174812_G();
        }
    }

    @Override
    public void func_213868_a(EntityRayTraceResult result) {
        if (this.func_234616_v_() != null) {
            if (result.func_216348_a() != null && result.func_216348_a() != this.func_234616_v_()) {
                result.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), this.damage);
            } else if (result.func_216348_a() == this.func_234616_v_() && this.func_234616_v_() instanceof PlayerEntity && this.bounces > 0) {
                if (!((PlayerEntity)this.func_234616_v_()).func_184812_l_()) {
                    ((PlayerEntity)this.func_234616_v_()).field_71071_by.func_70441_a(new ItemStack((IItemProvider)this.item));
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_174812_G();
                }
            }
            if (this.bounces == 0) {
                this.counter = 0;
                ++this.bounces;
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_174812_G();
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public boolean func_70039_c(CompoundNBT compound) {
        super.func_70039_c(compound);
        compound.func_74774_a("projectileId", this.getDiskId());
        return false;
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setDiskId(compound.func_74771_c("projectileId"));
        this.diskType = DiskType.getDiskFromOrdinal(this.getDiskId());
    }

    private byte getDiskId() {
        return (Byte)this.field_70180_af.func_187225_a(DISK_ID);
    }

    private void setDiskId(byte projectileId) {
        this.field_70180_af.func_187227_b(DISK_ID, (Object)projectileId);
    }

    public DiskType getDiskType() {
        if (this.diskType == null) {
            this.diskType = DiskType.getDiskFromOrdinal(this.getDiskId());
        }
        return this.diskType;
    }

    public ResourceLocation getTexture() {
        return this.getDiskType().getTexture();
    }
}

