/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.enums.ArrowType;
import divinerpg.registries.ParticleRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDivineArrow
extends AbstractArrowEntity {
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityDivineArrow.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ARROW_ID = EntityDataManager.func_187226_a(EntityDivineArrow.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    protected boolean field_70254_i;
    protected int timeInGround;
    public AbstractArrowEntity.PickupStatus pickupStatus = AbstractArrowEntity.PickupStatus.DISALLOWED;
    public int arrowShake;
    public Entity shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    public double damageMin;
    public double damageMax;
    private int knockbackStrength;
    private ArrowType arrowType;
    public Item ammoItem;

    public EntityDivineArrow(EntityType<? extends AbstractArrowEntity> type, World world) {
        super(type, world);
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrowEntity> type, World world, ArrowType arrowType, double x, double y, double z) {
        this(type, world);
        this.arrowType = arrowType;
        this.setArrowId((byte)arrowType.ordinal());
        this.damageMin = arrowType.getMinDamage();
        this.damageMax = arrowType.getMaxDamage();
        this.func_70107_b(x, y, z);
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrowEntity> type, World world, ArrowType arrowType, LivingEntity shooter) {
        this(type, world, arrowType, shooter.field_70169_q, shooter.field_70167_r + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70166_s);
        this.shootingEntity = shooter;
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrowEntity> type, World worldIn, ArrowType arrowType, LivingEntity shooter, LivingEntity target, float velocity, float inaccuracy) {
        this(type, worldIn, arrowType, shooter);
        double d0 = target.field_70169_q - this.field_70169_q;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_70047_e() / 3.0f) - this.field_70167_r;
        double d2 = target.field_70166_s - this.field_70166_s;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        this.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, velocity + arrowType.getMinDamage() / arrowType.getMaxDamage(), inaccuracy);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.shootingEntity = shooter;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.field_70180_af.func_187214_a(ARROW_ID, (Object)0);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, velocity, inaccuracy);
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213293_j(double x, double y, double z) {
        super.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70169_q, this.field_70167_r, this.field_70166_s, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        VoxelShape vox;
        double y;
        double x;
        super.func_70071_h_();
        if (this.getArrowType() == ArrowType.ETERNAL_ARCHER_FLAME_ARROW) {
            x = this.field_70169_q + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 4.0;
            y = this.field_70167_r + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 4.0;
            double z = this.field_70166_s + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 4.0;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, 0.0, 0.0, 0.0);
        } else if (this.getArrowType() == ArrowType.ETERNAL_ARCHER_WITHER_ARROW) {
            x = this.field_70169_q + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 4.0;
            y = this.field_70167_r + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 4.0;
            double z = this.field_70166_s + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) / 4.0;
            this.field_70170_p.func_195594_a((IParticleData)ParticleRegistry.BLACK_FLAME.get(), x, y, z, 0.0, 0.0, 0.0);
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().field_72450_a, (double)this.func_213322_ci().field_72449_c) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().field_72448_b, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        BlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (vox = iblockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)) != VoxelShapes.func_197880_a() && vox.func_197751_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p()).equals(new Vector3d(this.field_70169_q, this.field_70167_r, this.field_70166_s))) {
            this.field_70254_i = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.field_70254_i) {
            if (block != this.inTile && !this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_186662_g(0.05))) {
                this.field_70254_i = false;
                this.func_213293_j(this.func_213322_ci().field_72450_a * (double)this.field_70146_Z.nextFloat() * (double)0.2f, this.func_213322_ci().field_72448_b * (double)this.field_70146_Z.nextFloat() * (double)0.2f, this.func_213322_ci().field_72449_c * (double)this.field_70146_Z.nextFloat() * (double)0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInGround;
                if (this.ticksInGround >= 200 && this.getArrowType() == ArrowType.FROST_ARCHER_ARROW || this.ticksInGround >= 1200) {
                    this.func_174812_G();
                }
            }
            ++this.timeInGround;
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        LivingEntity entity;
        super.func_213868_a(result);
        if (result.func_216348_a() instanceof LivingEntity && (entity = (LivingEntity)result.func_216348_a()) != null) {
            float f = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c));
            int i = MathHelper.func_76143_f((double)((double)f * this.damageMin));
            if ((double)i > this.damageMax) {
                i = MathHelper.func_76143_f((double)this.damageMax);
            }
            if (this.getIsCritical()) {
                i += this.field_70146_Z.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = this.shootingEntity == null ? DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this) : DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this.shootingEntity);
            if (entity instanceof LivingEntity) {
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.WITHER) {
                    entity.func_195064_c(new EffectInstance(Effects.field_82731_v, 100, 2));
                } else if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.SLOW) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 2));
                } else if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.BLIND) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0));
                } else if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.NAUSEA) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
                }
            }
            if (!(entity instanceof EndermanEntity)) {
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.FLAME) {
                    entity.func_70015_d(12);
                } else if (this.func_70027_ad()) {
                    entity.func_70015_d(5);
                }
            }
            if (entity.func_70097_a(damagesource, (float)i)) {
                if (entity instanceof LivingEntity) {
                    float f1;
                    LivingEntity entitylivingbase = entity;
                    if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.POSION) {
                        entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 40, 2));
                    }
                    if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.EXPLODE) {
                        this.field_70170_p.func_217398_a((Entity)this, this.field_70169_q, this.field_70167_r, this.field_70166_s, 3.0f, false, Explosion.Mode.BREAK);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                    }
                    if (this.knockbackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c))) > 0.0f) {
                        entitylivingbase.func_213293_j(this.func_213322_ci().field_72450_a * (double)this.knockbackStrength * (double)0.6f / (double)f1, 0.1, this.func_213322_ci().field_72449_c * (double)this.knockbackStrength * (double)0.6f / (double)f1);
                    }
                    if (this.shootingEntity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)entitylivingbase, (Entity)this.shootingEntity);
                    }
                    if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof PlayerEntity && this.shootingEntity instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)this.shootingEntity).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EndermanEntity)) {
                    this.func_174812_G();
                }
            } else {
                this.func_213293_j(this.func_213322_ci().field_72450_a * (double)-0.1f, this.func_213322_ci().field_72448_b * (double)-0.1f, this.func_213322_ci().field_72449_c * (double)-0.1f);
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c < (double)0.001f) {
                    if (this.pickupStatus == AbstractArrowEntity.PickupStatus.ALLOWED) {
                        ItemEntity itemEnt = new ItemEntity(this.field_70170_p, this.field_70169_q, this.field_70167_r, this.field_70166_s);
                        itemEnt.func_92058_a(this.getArrowStack());
                        this.field_70170_p.func_217376_c((Entity)itemEnt);
                    }
                    this.func_174812_G();
                }
            }
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (result.hitInfo instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)result.hitInfo;
            if (entity != null) {
                float f = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c));
                int i = MathHelper.func_76143_f((double)((double)f * this.damageMin));
                if ((double)i > this.damageMax) {
                    i = MathHelper.func_76143_f((double)this.damageMax);
                }
                if (this.getIsCritical()) {
                    i += this.field_70146_Z.nextInt(i / 2 + 2);
                }
                DamageSource damagesource = this.shootingEntity == null ? DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this) : DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this.shootingEntity);
                if (entity instanceof LivingEntity) {
                    if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.WITHER) {
                        entity.func_195064_c(new EffectInstance(Effects.field_82731_v, 100, 2));
                    } else if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.SLOW) {
                        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 2));
                    } else if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.BLIND) {
                        entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0));
                    } else if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.NAUSEA) {
                        entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
                    }
                }
                if (!(entity instanceof EndermanEntity)) {
                    if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.FLAME) {
                        entity.func_70015_d(12);
                    } else if (this.func_70027_ad()) {
                        entity.func_70015_d(5);
                    }
                }
                if (entity.func_70097_a(damagesource, (float)i)) {
                    if (entity instanceof LivingEntity) {
                        float f1;
                        LivingEntity entitylivingbase = entity;
                        if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.POSION) {
                            entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 40, 2));
                        }
                        if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.EXPLODE) {
                            this.field_70170_p.func_217398_a((Entity)this, this.field_70169_q, this.field_70167_r, this.field_70166_s, 3.0f, false, Explosion.Mode.BREAK);
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                        }
                        if (this.knockbackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c))) > 0.0f) {
                            entitylivingbase.func_213293_j(this.func_213322_ci().field_72450_a * (double)this.knockbackStrength * (double)0.6f / (double)f1, 0.1, this.func_213322_ci().field_72449_c * (double)this.knockbackStrength * (double)0.6f / (double)f1);
                        }
                        if (this.shootingEntity instanceof LivingEntity) {
                            EnchantmentHelper.func_151384_a((LivingEntity)entitylivingbase, (Entity)this.shootingEntity);
                        }
                        if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof PlayerEntity && this.shootingEntity instanceof ServerPlayerEntity) {
                            ((ServerPlayerEntity)this.shootingEntity).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                        }
                    }
                    this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    if (!(entity instanceof EndermanEntity)) {
                        this.func_174812_G();
                    }
                } else {
                    this.func_213293_j(this.func_213322_ci().field_72450_a * (double)-0.1f, this.func_213322_ci().field_72448_b * (double)-0.1f, this.func_213322_ci().field_72449_c * (double)-0.1f);
                    this.field_70177_z += 180.0f;
                    this.field_70126_B += 180.0f;
                    this.ticksInAir = 0;
                    if (!this.field_70170_p.field_72995_K && this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c < (double)0.001f) {
                        if (this.pickupStatus == AbstractArrowEntity.PickupStatus.ALLOWED) {
                            ItemEntity itemEnt = new ItemEntity(this.field_70170_p, this.field_70169_q, this.field_70167_r, this.field_70166_s);
                            itemEnt.func_92058_a(this.getArrowStack());
                            this.field_70170_p.func_217376_c((Entity)itemEnt);
                        }
                        this.func_174812_G();
                    }
                }
            } else {
                BlockPos blockpos = new BlockPos(result.func_216347_e());
                this.xTile = blockpos.func_177958_n();
                this.yTile = blockpos.func_177956_o();
                this.zTile = blockpos.func_177952_p();
                this.func_213293_j(result.func_216347_e().field_72450_a - this.field_70169_q, result.func_216347_e().field_72448_b - this.field_70167_r, result.func_216347_e().field_72449_c - this.field_70166_s);
                float f2 = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c));
                this.field_70169_q -= this.func_213322_ci().field_72450_a / (double)f2 * (double)0.05f;
                this.field_70167_r -= this.func_213322_ci().field_72448_b / (double)f2 * (double)0.05f;
                this.field_70166_s -= this.func_213322_ci().field_72449_c / (double)f2 * (double)0.05f;
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.field_70254_i = true;
                this.arrowShake = 7;
                this.setIsCritical(false);
                if (this.getArrowType() == ArrowType.SNOWSTORM_ARROW) {
                    this.field_70170_p.func_217398_a((Entity)this, this.field_70169_q, this.field_70167_r, this.field_70166_s, 3.0f, false, Explosion.Mode.BREAK);
                    this.func_174812_G();
                }
            }
        }
    }

    public void func_213315_a(MoverType type, Vector3d vec) {
        super.func_213315_a(type, vec);
        if (this.field_70254_i) {
            this.xTile = MathHelper.func_76128_c((double)this.field_70169_q);
            this.yTile = MathHelper.func_76128_c((double)this.field_70167_r);
            this.zTile = MathHelper.func_76128_c((double)this.field_70166_s);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        compound.func_74777_a("life", (short)this.ticksInGround);
        compound.func_74774_a("inData", (byte)this.inData);
        compound.func_74774_a("shake", (byte)this.arrowShake);
        compound.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        compound.func_74774_a("pickup", (byte)this.pickupStatus.ordinal());
        compound.func_74780_a("damage", this.damageMin);
        compound.func_74757_a("crit", this.getIsCritical());
        compound.func_74774_a("arrowId", this.getArrowId());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.ticksInGround = compound.func_74765_d("life");
        this.inData = compound.func_74771_c("inData") & 0xFF;
        this.arrowShake = compound.func_74771_c("shake") & 0xFF;
        boolean bl = this.field_70254_i = compound.func_74771_c("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.damageMin = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.pickupStatus = AbstractArrowEntity.PickupStatus.func_188795_a((int)compound.func_74771_c("pickup"));
        } else if (compound.func_150297_b("player", 99)) {
            this.pickupStatus = compound.func_74767_n("player") ? AbstractArrowEntity.PickupStatus.ALLOWED : AbstractArrowEntity.PickupStatus.DISALLOWED;
        }
        this.setIsCritical(compound.func_74767_n("crit"));
        this.setArrowId(compound.func_74771_c("arrowId"));
        this.arrowType = ArrowType.getArrowFromId(this.getArrowId());
        this.damageMax = this.arrowType.getMaxDamage();
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.pickupStatus == AbstractArrowEntity.PickupStatus.ALLOWED || this.pickupStatus == AbstractArrowEntity.PickupStatus.CREATIVE_ONLY && entityIn.func_184812_l_();
            if (this.pickupStatus == AbstractArrowEntity.PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.getArrowStack())) {
                flag = false;
            }
            if (flag) {
                this.func_174812_G();
            }
        }
    }

    protected ItemStack func_184550_j() {
        return this.getArrowStack();
    }

    public void func_70240_a(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    public void setIsCritical(boolean critical) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        if (critical) {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean getIsCritical() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 1) != 0;
    }

    public void func_174815_a(LivingEntity p_174815_1_, Entity p_174815_2_) {
    }

    public void setDamage(double damageIn) {
        this.damageMin = damageIn;
    }

    public double getDamage() {
        return this.damageMin;
    }

    private byte getArrowId() {
        return (Byte)this.field_70180_af.func_187225_a(ARROW_ID);
    }

    private void setArrowId(byte projectileId) {
        this.field_70180_af.func_187227_b(ARROW_ID, (Object)projectileId);
    }

    public ArrowType getArrowType() {
        if (this.arrowType == null) {
            this.arrowType = ArrowType.getArrowFromId(this.getArrowId());
        }
        return this.arrowType;
    }

    public ResourceLocation getTexture() {
        return this.getArrowType().getTexture();
    }

    public void setAmmoItem(Item ammo, boolean infiniteAmmo) {
        this.ammoItem = ammo;
        if (infiniteAmmo) {
            this.pickupStatus = AbstractArrowEntity.PickupStatus.DISALLOWED;
        }
    }

    protected ItemStack getArrowStack() {
        return new ItemStack((IItemProvider)this.ammoItem);
    }
}

