/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import com.google.common.collect.Maps;
import divinerpg.entities.iceika.EntityAlicanto;
import divinerpg.entities.iceika.EntityFractite;
import divinerpg.entities.iceika.EntityFrostArcher;
import divinerpg.entities.iceika.EntityFrosty;
import divinerpg.entities.iceika.EntityGlacide;
import divinerpg.entities.iceika.EntityHastreus;
import divinerpg.entities.iceika.EntityRollum;
import divinerpg.entities.vanilla.overworld.EntityFrost;
import divinerpg.entities.vanilla.overworld.EntityGlacon;
import divinerpg.registries.ParticleRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityFrostCloud
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntityFrostCloud.class, (IDataSerializer)DataSerializers.field_187193_c);
    private final Map<Entity, Integer> reapplicationDelayMap = Maps.newHashMap();
    private int duration = 600;
    private int reapplicationDelay = 10;
    private float radiusPerTick;
    private LivingEntity owner;
    private UUID ownerUniqueId;
    private PlayerEntity player;

    public EntityFrostCloud(EntityType<?> type, World world) {
        super(type, world);
        this.field_70145_X = true;
    }

    public EntityFrostCloud(EntityType<?> type, World world, double x, double y, double z) {
        this(type, world);
        this.func_70107_b(x, y, z);
    }

    public boolean func_230279_az_() {
        return true;
    }

    public float func_70111_Y() {
        return 3.0f;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RADIUS, (Object)Float.valueOf(3.0f));
    }

    public int getDuration() {
        return this.duration;
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUniqueId)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public float getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(RADIUS)).floatValue();
    }

    public void func_184206_a(DataParameter<?> key) {
        if (RADIUS.equals(key)) {
            this.setRadius(this.getRadius());
        }
        super.func_184206_a(key);
    }

    public void func_70071_h_() {
        block8: {
            float f;
            block7: {
                super.func_70071_h_();
                f = this.getRadius();
                if (!this.field_70170_p.field_72995_K) break block7;
                float f5 = (float)Math.PI * f * f;
                int k1 = 0;
                while ((float)k1 < f5) {
                    float f6 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float f7 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * f;
                    float f8 = MathHelper.func_76134_b((float)f6) * f7;
                    float f9 = MathHelper.func_76126_a((float)f6) * f7;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleRegistry.FROST.get(), this.field_70169_q + (double)f8, this.field_70167_r, this.field_70166_s + (double)f9, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15);
                    ++k1;
                }
                break block8;
            }
            if (this.field_70173_aa >= this.duration) {
                this.func_174812_G();
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.func_174812_G();
                    return;
                }
                this.setRadius(f);
            }
            if (this.field_70173_aa % 5 != 0) break block8;
            Iterator<Map.Entry<Entity, Integer>> iterator = this.reapplicationDelayMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Entity, Integer> entry = iterator.next();
                if (this.field_70173_aa < entry.getValue()) continue;
                iterator.remove();
            }
            List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ());
            if (!list.isEmpty()) {
                for (LivingEntity entity : list) {
                    double d1;
                    double d0;
                    double d2;
                    if (this.reapplicationDelayMap.containsKey(entity) || !entity.func_184603_cC() || !((d2 = (d0 = entity.field_70169_q - this.field_70169_q) * d0 + (d1 = entity.field_70166_s - this.field_70166_s) * d1) <= (double)(f * f))) continue;
                    this.reapplicationDelayMap.put((Entity)entity, this.field_70173_aa + this.reapplicationDelay);
                    if (entity.func_233643_dh_() || entity instanceof SnowGolemEntity || entity instanceof EntityGlacon || entity instanceof EntityFrost || entity instanceof EntityAlicanto || entity instanceof EntityFractite || entity instanceof EntityFrostArcher || entity instanceof EntityFrosty || entity instanceof EntityGlacide || entity instanceof EntityHastreus || entity instanceof EntityRollum) continue;
                    entity.func_70097_a(DamageSource.field_76376_m, 1.0f);
                }
            }
        }
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void setOwner(@Nullable LivingEntity ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.func_110124_au();
    }

    public void setRadius(float radiusIn) {
        double d0 = this.field_70169_q;
        double d1 = this.field_70167_r;
        double d2 = this.field_70166_s;
        this.func_70107_b(d0, d1, d2);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(RADIUS, (Object)Float.valueOf(radiusIn));
        }
    }

    public void setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.duration = compound.func_74762_e("Duration");
        this.reapplicationDelay = compound.func_74762_e("ReapplicationDelay");
        this.radiusPerTick = compound.func_74760_g("RadiusPerTick");
        this.setRadius(compound.func_74760_g("Radius"));
        this.ownerUniqueId = compound.func_186857_a("OwnerUUID");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        compound.func_74768_a("Duration", this.duration);
        compound.func_74768_a("ReapplicationDelay", this.reapplicationDelay);
        compound.func_74776_a("RadiusPerTick", this.radiusPerTick);
        compound.func_74776_a("Radius", this.getRadius());
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

