/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.entities.projectile.DivineThrowable;
import divinerpg.enums.BulletType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;

public class EntityShooterBullet
extends DivineThrowable {
    private static final DataParameter<Byte> BULLET_ID = EntityDataManager.func_187226_a(EntityShooterBullet.class, (IDataSerializer)DataSerializers.field_187191_a);
    private BulletType bulletType;

    public EntityShooterBullet(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
    }

    public EntityShooterBullet(EntityType<? extends ThrowableEntity> type, LivingEntity entity, World world, BulletType bulletType) {
        super(type, entity, world);
        this.bulletType = bulletType;
        this.setBulletId((byte)bulletType.ordinal());
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BULLET_ID, (Object)0);
    }

    @Override
    public void func_213868_a(EntityRayTraceResult result) {
        if (result.func_216348_a() != null) {
            Entity entity = result.func_216348_a();
            entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), this.getBulletType().getDamage());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_174812_G();
        }
    }

    public boolean func_70039_c(CompoundNBT compound) {
        super.func_70039_c(compound);
        compound.func_74774_a("projectileId", this.getBulletId());
        return false;
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setBulletId(compound.func_74771_c("projectileId"));
        this.bulletType = BulletType.getBulletFromOrdinal(this.getBulletId());
    }

    private byte getBulletId() {
        return (Byte)this.field_70180_af.func_187225_a(BULLET_ID);
    }

    private void setBulletId(byte projectileId) {
        this.field_70180_af.func_187227_b(BULLET_ID, (Object)projectileId);
    }

    public BulletType getBulletType() {
        if (this.bulletType == null) {
            this.bulletType = BulletType.getBulletFromOrdinal(this.getBulletId());
        }
        return this.bulletType;
    }

    public ResourceLocation getTexture() {
        return this.getBulletType().getTexture();
    }
}

