/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.nether;

import divinerpg.entities.base.EntityDivineMob;
import divinerpg.entities.projectile.EntityScorcherShot;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityScorcher
extends EntityDivineMob {
    private float allowedHeightOffset = 0.5f;
    private int nextHeightOffsetChangeTick;
    private static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(EntityScorcher.class, (IDataSerializer)DataSerializers.field_187191_a);

    public EntityScorcher(EntityType<? extends EntityScorcher> type, World level) {
        super(type, level);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 20;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new FireballAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.SCORCHER;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    public boolean func_230270_dK_() {
        return true;
    }

    protected void func_70619_bc() {
        LivingEntity livingentity;
        --this.nextHeightOffsetChangeTick;
        if (this.nextHeightOffsetChangeTick <= 0) {
            this.nextHeightOffsetChangeTick = 100;
            this.allowedHeightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((livingentity = this.func_70638_az()) != null && livingentity.func_226280_cw_() > this.func_226280_cw_() + (double)this.allowedHeightOffset && this.func_213336_c(livingentity)) {
            Vector3d vector3d = this.func_213322_ci();
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vector3d.field_72448_b) * (double)0.3f, 0.0));
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public boolean func_225503_b_(float i, float y) {
        return false;
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return true;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, EntityStats.scorcherDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.scorcherSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.scorcherFollowRange).func_233815_a_(Attributes.field_233818_a_, EntityStats.scorcherHealth);
    }

    static class FireballAttackGoal
    extends Goal {
        private final EntityScorcher scorcher;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public FireballAttackGoal(EntityScorcher scorcher) {
            this.scorcher = scorcher;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.scorcher.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.scorcher.func_213336_c(livingentity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.lastSeen = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingentity = this.scorcher.func_70638_az();
            if (livingentity != null) {
                boolean flag = this.scorcher.func_70635_at().func_75522_a((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.scorcher.func_70068_e((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.scorcher.func_70652_k((Entity)livingentity);
                    }
                    this.scorcher.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.func_226277_ct_() - this.scorcher.func_226277_ct_();
                    double d2 = livingentity.func_226283_e_(0.5) - this.scorcher.func_226283_e_(0.5);
                    double d3 = livingentity.func_226281_cx_() - this.scorcher.func_226281_cx_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                            if (!this.scorcher.func_174814_R()) {
                                this.scorcher.field_70170_p.func_217378_a((PlayerEntity)null, 1018, this.scorcher.func_233580_cy_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                if (!this.scorcher.func_70089_S()) continue;
                                EntityScorcherShot projectile = new EntityScorcherShot(this.scorcher.field_70170_p, (LivingEntity)this.scorcher, 1.4, 1.4, 1.4);
                                double livingX = livingentity.func_226277_ct_() - this.scorcher.func_226277_ct_();
                                double livingY = livingentity.func_226283_e_(0.3333333333333333) - projectile.func_226278_cu_() - 0.4;
                                double livingZ = livingentity.func_226281_cx_() - this.scorcher.func_226281_cx_();
                                double randomness = MathHelper.func_76133_a((double)(livingX * livingX + livingZ * livingZ));
                                projectile.func_70186_c(livingX, livingY + randomness * (double)0.2f, livingZ, 1.6f, 14 - this.scorcher.field_70170_p.func_175659_aa().func_151525_a() * 4);
                                this.scorcher.field_70170_p.func_217376_c((Entity)projectile);
                            }
                        }
                    }
                    this.scorcher.func_70671_ap().func_75651_a((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.scorcher.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                }
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.scorcher.func_233637_b_(Attributes.field_233819_b_);
        }
    }
}

