/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineWaterMob;
import divinerpg.util.EntityStats;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EntityAequorea
extends EntityDivineWaterMob {
    int colour = this.func_70681_au().nextInt(5);

    public EntityAequorea(EntityType<? extends EntityAequorea> type, World worldIn) {
        super(type, worldIn);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.3f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MoveRandomGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new StingAttack((CreatureEntity)this, EntityStats.aequoreaSpeed, false));
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.aequoreaHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.aequoreaDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.aequoreaSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.aequoreaFollowRange);
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.func_70090_H()) {
            Vector3d vec3d = this.func_174824_e(0.0f);
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d.field_72450_a * 1.5, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - vec3d.field_72448_b * 1.5, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d.field_72449_c * 1.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.func_70090_H()) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.field_70125_A = this.field_70146_Z.nextFloat() * 360.0f;
            this.field_70122_E = false;
            this.field_70703_bu = true;
            if (this.field_70170_p.func_82737_E() % 5L == 0L) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187684_cg, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.func_70097_a(DamageSource.field_76369_e, 0.5f);
        }
        super.func_70071_h_();
    }

    class StingAttack
    extends Goal {
        protected final CreatureEntity mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private final int attackInterval = 20;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;

        public StingAttack(CreatureEntity aequorea, double speed, boolean followAtAllCosts) {
            this.mob = aequorea;
            this.speedModifier = speed;
            this.followingTargetEvenIfNotSeen = followAtAllCosts;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            long i = this.mob.field_70170_p.func_82737_E();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.func_70661_as().func_75494_a((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.func_70681_au().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.func_70661_as().func_75494_a((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.mob.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.func_70661_as().func_75500_f();
            }
            if (!this.mob.func_213389_a(livingentity.func_233580_cy_())) {
                return false;
            }
            return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
        }

        public void func_75249_e() {
            this.mob.func_70661_as().func_75484_a(this.path, this.speedModifier);
            this.mob.func_213395_q(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void func_75251_c() {
            LivingEntity livingentity = this.mob.func_70638_az();
            if (!EntityPredicates.field_188444_d.test(livingentity)) {
                this.mob.func_70624_b((LivingEntity)null);
            }
            this.mob.func_213395_q(false);
            this.mob.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.mob.func_70638_az();
            this.mob.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            double d0 = this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.func_70635_at().func_75522_a((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.func_70092_e(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.func_70681_au().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.func_226277_ct_();
                this.pathedTargetY = livingentity.func_226278_cu_();
                this.pathedTargetZ = livingentity.func_226281_cx_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.func_70681_au().nextInt(7);
                if (this.canPenalize) {
                    PathPoint finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.mob.func_70661_as().func_75505_d().func_75870_c()) != null && livingentity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.func_70661_as().func_75497_a((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity, d0);
        }

        protected void checkAndPerformAttack(LivingEntity entity, double range) {
            double d0 = this.getAttackReachSqr(entity);
            if (range <= d0 && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.func_184609_a(Hand.MAIN_HAND);
                this.mob.func_70652_k((Entity)entity);
                entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 3));
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 20;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.func_213311_cf() * 2.0f * this.mob.func_213311_cf() * 2.0f + p_179512_1_.func_213311_cf();
        }
    }

    class MoveRandomGoal
    extends Goal {
        private final EntityAequorea jellyfish;

        public MoveRandomGoal(EntityAequorea jellyfish) {
            this.jellyfish = jellyfish;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.jellyfish.func_70654_ax();
            if (i > 100) {
                this.jellyfish.func_213293_j(0.0, 0.0, 0.0);
            } else if (this.jellyfish.func_70681_au().nextInt(50) == 0 || !this.jellyfish.func_70090_H() || !this.jellyfish.func_225502_at_()) {
                float f = this.jellyfish.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.jellyfish.func_70681_au().nextFloat() * 0.1f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.jellyfish.func_213293_j(f1, f2, f3);
            }
        }
    }
}

