/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMob;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityJungleSpider
extends EntityDivineMob {
    private static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(EntityJungleSpider.class, (IDataSerializer)DataSerializers.field_187191_a);

    public EntityJungleSpider(EntityType<? extends EntityJungleSpider> p_i48550_1_, World p_i48550_2_) {
        super(p_i48550_1_, p_i48550_2_);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new TargetGoal<PlayerEntity>(this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, new TargetGoal<IronGolemEntity>(this, IronGolemEntity.class));
    }

    public double func_70042_X() {
        return this.func_213302_cg() * 0.5f;
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        return new ClimberPathNavigator((MobEntity)this, p_175447_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setClimbing(this.field_70123_F);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.isClimbing();
    }

    public void func_213295_a(BlockState p_213295_1_, Vector3d p_213295_2_) {
        if (!p_213295_1_.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(p_213295_1_, p_213295_2_);
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70687_e(EffectInstance p_70687_1_) {
        if (p_70687_1_.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, p_70687_1_);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(p_70687_1_);
    }

    public boolean isClimbing() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_70839_1_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        b0 = p_70839_1_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)b0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        Effect effect;
        p_213386_4_ = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        if (p_213386_1_.func_201674_k().nextInt(100) == 0) {
            SkeletonEntity skeletonentity = (SkeletonEntity)EntityType.field_200741_ag.func_200721_a(this.field_70170_p);
            skeletonentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            skeletonentity.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, (ILivingEntityData)null, (CompoundNBT)null);
            skeletonentity.func_184220_m((Entity)this);
        }
        if (p_213386_4_ == null) {
            p_213386_4_ = new GroupData();
            if (p_213386_1_.func_175659_aa() == Difficulty.HARD && p_213386_1_.func_201674_k().nextFloat() < 0.1f * p_213386_2_.func_180170_c()) {
                ((GroupData)p_213386_4_).setRandomEffect(p_213386_1_.func_201674_k());
            }
        }
        if (p_213386_4_ instanceof GroupData && (effect = ((GroupData)p_213386_4_).effect) != null) {
            this.func_195064_c(new EffectInstance(effect, Integer.MAX_VALUE));
        }
        return p_213386_4_;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 0.65f;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.jungleSpiderHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.jungleSpiderDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.jungleSpiderSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.follow);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.JUNGLE_SPIDER;
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return true;
    }

    public float func_205022_a(BlockPos pos, IWorldReader reader) {
        return 0.0f;
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(EntityJungleSpider p_i45818_1_, Class<T> p_i45818_2_) {
            super((MobEntity)p_i45818_1_, p_i45818_2_, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f >= 0.5f ? false : super.func_75250_a();
        }
    }

    public static class GroupData
    implements ILivingEntityData {
        public Effect effect;

        public void setRandomEffect(Random p_111104_1_) {
            int i = p_111104_1_.nextInt(5);
            if (i <= 1) {
                this.effect = Effects.field_76424_c;
            } else if (i <= 2) {
                this.effect = Effects.field_76420_g;
            } else if (i <= 3) {
                this.effect = Effects.field_76428_l;
            } else if (i <= 4) {
                this.effect = Effects.field_76441_p;
            }
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(EntityJungleSpider p_i46676_1_) {
            super((CreatureEntity)p_i46676_1_, 1.0, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_75441_b.func_184207_aI();
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((LivingEntity)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return 4.0f + p_179512_1_.func_213311_cf();
        }
    }
}

