/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.util.EntityStats;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityPumpkinSpider
extends SpiderEntity {
    private static final DataParameter<Boolean> PROVOKED = EntityDataManager.func_187226_a(EntityPumpkinSpider.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityPumpkinSpider(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.pumpkinSpiderHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.pumpkinSpiderDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.pumpkinSpiderSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.pumpkinSpiderFollowRange);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROVOKED, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, 4.0);
            if (player != null && this.func_70685_l((Entity)player)) {
                this.setProvoked((LivingEntity)player);
            } else {
                this.setProvoked(this.func_70638_az());
            }
            this.func_94061_f((Boolean)this.field_70180_af.func_187225_a(PROVOKED) == false);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76364_f();
        if (entity instanceof LivingEntity) {
            this.setProvoked((LivingEntity)entity);
            this.func_213293_j(0.0, 0.6, 0.0);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean getProvoked() {
        return (Boolean)this.field_70180_af.func_187225_a(PROVOKED);
    }

    @Nullable
    public void setProvoked(LivingEntity entity) {
        if (entity == null || !this.func_70685_l((Entity)entity) && entity.func_70032_d((Entity)this) > 32.0f) {
            this.calmDown();
        } else {
            PlayerEntity player;
            if (entity instanceof PlayerEntity && ((player = (PlayerEntity)entity).func_184812_l_() || player.func_175149_v())) {
                this.calmDown();
                return;
            }
            this.field_70180_af.func_187227_b(PROVOKED, (Object)true);
            this.func_70624_b(entity);
        }
    }

    public void calmDown() {
        this.field_70180_af.func_187227_b(PROVOKED, (Object)false);
        this.func_70624_b(null);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74767_n("Provoked")) {
            this.setProvoked(null);
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("Provoked", this.getProvoked());
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return true;
    }

    public float func_205022_a(BlockPos pos, IWorldReader reader) {
        return 0.0f;
    }
}

