/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineFlyingMob;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityRainbour
extends EntityDivineFlyingMob {
    private int angerLevel;
    private UUID angerTargetUUID;
    private static final DataParameter<IParticleData> PARTICLE = EntityDataManager.func_187226_a(EntityRainbour.class, (IDataSerializer)DataSerializers.field_198166_i);

    public EntityRainbour(EntityType<? extends EntityDivineFlyingMob> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new RainbourLookController((MobEntity)this);
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, EntityStats.rainbourHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.rainbourDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.rainbourSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.rainbourFollowRange).func_233815_a_(Attributes.field_233822_e_, EntityStats.rainbourSpeed);
    }

    public float func_213307_e(Pose pose) {
        return 0.6f;
    }

    public void func_70624_b(@Nullable LivingEntity livingBase) {
        super.func_70624_b(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.angerLevel = tag.func_74765_d("Anger");
        String s = tag.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            PlayerEntity entityplayer = this.func_130014_f_().func_217371_b(this.angerTargetUUID);
            this.func_70624_b((LivingEntity)entityplayer);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70737_aN = this.func_142015_aE();
            }
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            tag.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            tag.func_74778_a("HurtBy", "");
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76364_f();
        if (entity instanceof PlayerEntity) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    private void becomeAngryAt(Entity target) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        if (target instanceof LivingEntity) {
            this.func_70624_b((LivingEntity)target);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.isAngry()) {
            return super.func_70652_k(entity);
        }
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.6f;
    }

    public int func_70641_bl() {
        return 1;
    }

    public IParticleData getParticleData() {
        return (IParticleData)this.func_184212_Q().func_187225_a(PARTICLE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70071_h_() {
        super.func_70071_h_();
        for (int var3 = 0; var3 < 8; ++var3) {
            double d15 = this.func_226277_ct_() + this.field_70146_Z.nextDouble() * 0.6 + 0.2;
            double d20 = this.func_226278_cu_() + this.field_70146_Z.nextDouble() * 0.6 + 0.2;
            double d26 = this.func_226281_cx_() + this.field_70146_Z.nextDouble() * 0.6 + 0.2;
            if (!this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_195594_a((IParticleData)ParticleRegistry.SPARKLER.get(), d15 * (double)this.func_213311_cf(), d20 + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, d26 * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.RAINBOUR;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.RAINBOUR_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.RAINBOUR_HURT;
    }

    class RainbourLookController
    extends LookController {
        RainbourLookController(MobEntity entity) {
            super(entity);
        }

        public void func_75649_a() {
            if (!EntityRainbour.this.isAngry()) {
                super.func_75649_a();
            }
        }
    }
}

