/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMob;
import divinerpg.entities.projectile.EntitySaguaroWormShot;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntitySaguaroWorm
extends EntityDivineMob {
    private static final DataParameter<Boolean> PROVOKED = EntityDataManager.func_187226_a(EntitySaguaroWorm.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntitySaguaroWorm(EntityType<? extends EntitySaguaroWorm> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean needsSpecialAI() {
        return true;
    }

    public double func_70033_W() {
        return 2.5;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROVOKED, (Object)false);
    }

    public boolean getProvoked() {
        return (Boolean)this.field_70180_af.func_187225_a(PROVOKED);
    }

    public void setProvoked(boolean provoked) {
        this.field_70180_af.func_187227_b(PROVOKED, (Object)provoked);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() > 0.0f) {
            PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, 10.0);
            if (player != null && !player.func_184812_l_() && !player.func_175149_v() && this.func_70685_l((Entity)player)) {
                this.func_70624_b((LivingEntity)player);
                this.func_94061_f(false);
                this.setProvoked(true);
                if (this.field_70173_aa % 50 == 0) {
                    this.attack((LivingEntity)player);
                }
            } else {
                this.func_70624_b(null);
                this.setProvoked(false);
                this.func_94061_f(true);
            }
        }
        if (!this.getProvoked()) {
            this.field_70127_C = 0.0f;
        }
    }

    public void attack(LivingEntity e) {
        if (this.func_70638_az() != null && this.func_70089_S() && this.func_213336_c(this.func_70638_az())) {
            double y = this.func_174813_aQ().field_72338_b + 2.7;
            double tx = e.func_226277_ct_() - this.func_226277_ct_();
            double ty = e.func_174813_aQ().field_72338_b - y;
            double tz = e.func_226281_cx_() - this.func_226281_cx_();
            for (double h = -1.5; h < 1.5; h += 0.5) {
                for (double r = 0.0; r < 1.5 - Math.abs(h); r += 0.5) {
                    for (double theta = 0.0; theta < Math.PI * 2; theta += 1.5707963267948966) {
                        EntitySaguaroWormShot shot = new EntitySaguaroWormShot(EntityRegistry.SAGUARO_WORM_SHOT, (LivingEntity)this, this.field_70170_p);
                        shot.field_70169_q = this.field_70169_q + r * Math.cos(theta);
                        shot.field_70167_r = this.field_70167_r + 5.0 + h;
                        shot.field_70166_s = this.field_70166_s + r * Math.sin(theta);
                        shot.func_70186_c(tx, ty, tz, 0.9f, 5.0f);
                        this.field_70170_p.func_217376_c((Entity)shot);
                    }
                }
            }
        }
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.saguaroWormHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.saguaroWormDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.saguaroWormSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.saguaroWormFollowRange);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setProvoked(tag.func_74767_n("Provoked"));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("Provoked", this.getProvoked());
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.SAGUARO_WORM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SAGUARO_WORM;
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150354_m;
    }

    public float func_205022_a(BlockPos pos, IWorldReader reader) {
        return 0.0f;
    }
}

