/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityVetheaMob;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.EntityStats;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityLorgaflight
extends EntityVetheaMob {
    private BlockPos currentFlightTarget;
    private int flyTimer;
    private int spawnTick;
    public boolean canSpawnMinions;

    public EntityLorgaflight(EntityType<? extends MobEntity> type, World worldIn) {
        this(type, worldIn, true);
    }

    public EntityLorgaflight(EntityType<? extends MobEntity> type, World worldIn, boolean canSpawnMinions) {
        super(type, worldIn);
        this.canSpawnMinions = canSpawnMinions;
        this.flyTimer = 0;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.8f;
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, EntityStats.lorgaFlightHealth).func_233815_a_(Attributes.field_233823_f_, EntityStats.lorgaFlightDamage).func_233815_a_(Attributes.field_233821_d_, EntityStats.lorgaFlightSpeed).func_233815_a_(Attributes.field_233819_b_, EntityStats.lorgaFlightFollowRange);
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(pos.func_177977_b()).func_215688_a((IBlockReader)worldIn, pos.func_177977_b(), typeIn);
    }

    @Override
    public int getSpawnLayer() {
        return 3;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected int func_225508_e_(float p_225508_1_, float p_225508_2_) {
        return 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213293_j(this.func_213322_ci().field_72450_a, 0.6f, this.func_213322_ci().field_72448_b);
        if (this.spawnTick == 0 && this.canSpawnMinions && !this.field_70170_p.field_72995_K) {
            this.spawnTick = 200;
            EntityLorgaflight var2 = new EntityLorgaflight(EntityRegistry.LORGA_FLIGHT, this.field_70170_p, false);
            var2.func_70012_b(this.func_226277_ct_() + 1.0, this.func_226278_cu_(), this.func_226281_cx_() + 1.0, this.field_70125_A, this.field_70177_z);
            this.field_70170_p.func_217376_c((Entity)var2);
        } else if (this.spawnTick > 0) {
            --this.spawnTick;
        }
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.func_70638_az() != null) {
            int var1 = (int)this.func_70638_az().func_226277_ct_();
            int var2 = (int)this.func_70638_az().func_226278_cu_();
            int var3 = (int)this.func_70638_az().func_226281_cx_();
            this.currentFlightTarget = new BlockPos(var1, var2, var3);
        } else if (this.flyTimer != 0) {
            this.flyTimer = 120;
            this.currentFlightTarget = new BlockPos((int)(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(16)) - 8, (int)(this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(32)) - 16, (int)(this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(16)) - 8);
        }
        if (this.currentFlightTarget != null) {
            double var1 = (double)this.currentFlightTarget.func_177958_n() - this.func_226277_ct_();
            double var3 = (double)this.currentFlightTarget.func_177956_o() - this.func_226278_cu_();
            double var5 = (double)this.currentFlightTarget.func_177952_p() - this.func_226281_cx_();
            if (Math.signum(var1) != 0.0 || Math.signum(var3) != 0.0 || Math.signum(var5) != 0.0) {
                this.func_213293_j((Math.signum(var1) * 0.15 - this.func_213322_ci().field_72450_a) * (double)0.1f, (Math.signum(var3) * 1.699999988079071 - this.func_213322_ci().field_72448_b) * (double)0.1f, (Math.signum(var5) * 0.15 - this.func_213322_ci().field_72449_c) * (double)0.1f);
                float var7 = (float)(Math.atan2(this.func_213322_ci().field_72449_c, this.func_213322_ci().field_72449_c) * 180.0 / Math.PI) - 90.0f;
                float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70125_A));
                this.field_70140_Q = 0.5f;
                this.field_70125_A += var8;
            }
            --this.flyTimer;
        }
        this.addAttackingAI();
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("CanSpawnMinions", this.canSpawnMinions);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.canSpawnMinions = tag.func_74767_n("CanSpawnMinions");
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.LORGAFLIGHT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.LORGAFLIGHT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.LORGAFLIGHT_HURT;
    }
}

