/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.enums;

import net.minecraft.util.ResourceLocation;

public enum DiskType {
    NONE(0.0f, null),
    TEAKER_DISK(4.0f, DiskType.ItemLoc("teaker_disk")),
    AMTHRIMIS_DISK(6.0f, DiskType.ItemLoc("amthirmis_disk")),
    DARVEN_DISK(9.0f, DiskType.ItemLoc("darven_disk")),
    CERMILE_DISK(13.0f, DiskType.ItemLoc("cermile_disk")),
    PARDIMAL_DISK(16.0f, DiskType.ItemLoc("pardimal_disk")),
    QUADROTIC_DISK(20.0f, DiskType.ItemLoc("quadrotic_disk")),
    KAROS_DISK(22.0f, DiskType.ItemLoc("karos_disk")),
    HELIOSIS_DISK(29.0f, DiskType.ItemLoc("heliosis_disk")),
    ARKSIANE_DISK(37.0f, DiskType.ItemLoc("arksiane_disk"));

    private final float damage;
    private final ResourceLocation texture;

    private DiskType(float damage, ResourceLocation texture) {
        this.damage = damage;
        this.texture = texture;
    }

    public float getDamage() {
        return this.damage;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public static DiskType getDiskFromOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal > DiskType.values().length) {
            ordinal = 0;
        }
        return DiskType.values()[ordinal];
    }

    private static ResourceLocation ItemLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/items/" + name + ".png");
    }
}

