/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events.enchant;

import divinerpg.registries.EnchantmentRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RiveHandler {
    @SubscribeEvent
    public void handleWorldBreak(BlockEvent.BreakEvent event) {
        World world = (World)event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.func_213453_ef()) {
            return;
        }
        ItemStack itemStack = event.getPlayer().func_184614_ca();
        if (!(itemStack.func_77973_b() instanceof ToolItem)) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)EnchantmentRegistry.RIVE, (LivingEntity)player);
        if (level < 1) {
            return;
        }
        Direction facing = player.func_174811_aO();
        int[] dimensions = this.getSizeByDirection(facing, level);
        for (int x = dimensions[0]; x <= dimensions[3]; ++x) {
            for (int y = dimensions[1]; y <= dimensions[4]; ++y) {
                for (int z = dimensions[2]; z <= dimensions[5]; ++z) {
                    BlockPos pos = event.getPos().func_177982_a(x, y, z);
                    this.tryToBreakBlock(world, player, pos, world.func_180495_p(pos), itemStack);
                }
            }
        }
    }

    private void tryToBreakBlock(World world, PlayerEntity player, BlockPos pos, BlockState blockState, ItemStack tool) {
        if (blockState.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        if (!ForgeHooks.canHarvestBlock((BlockState)blockState, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos)) {
            return;
        }
        if (!(blockState.func_177230_c().isToolEffective(blockState, ToolType.AXE) || blockState.func_177230_c().isToolEffective(blockState, ToolType.HOE) || blockState.func_177230_c().isToolEffective(blockState, ToolType.PICKAXE) || blockState.func_177230_c().isToolEffective(blockState, ToolType.SHOVEL))) {
            return;
        }
        if (blockState.func_177230_c() instanceof TorchBlock) {
            return;
        }
        if (blockState.func_177230_c() instanceof DoorBlock) {
            return;
        }
        if (blockState.hasTileEntity()) {
            return;
        }
        Block block = blockState.func_177230_c();
        if (!player.func_184812_l_()) {
            block.func_180657_a(world, player, pos, blockState, null, tool);
            world.func_175655_b(pos, false);
            tool.func_222118_a(1, (LivingEntity)player, context -> context.func_213334_d(player.func_184600_cs()));
        } else {
            world.func_175655_b(pos, false);
        }
    }

    private int[] getSizeByDirection(Direction facing, int level) {
        int depth = level - 1;
        switch (facing) {
            case NORTH: {
                return new int[]{-1, -1, 0 - depth, 1, 1, 0};
            }
            case EAST: {
                return new int[]{0, -1, -1, 0 + depth, 1, 1};
            }
            case WEST: {
                return new int[]{0 - depth, -1, -1, 0, 1, 1};
            }
            case SOUTH: {
                return new int[]{-1, -1, 0, 1, 1, 0 + depth};
            }
            case UP: {
                return new int[]{-1, 0, -1, 1, 0 + depth, 1};
            }
            case DOWN: {
                return new int[]{-1, 0 - depth, -1, 1, 0, 1};
            }
        }
        return new int[]{0, 0, 0, 0, 0, 0};
    }
}

