/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import divinerpg.DivineRPG;
import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaCapability;
import divinerpg.items.base.ItemModSword;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.RarityList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemArcanaPoweredSword
extends ItemModSword {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    protected static final UUID ATTACK_MODIFIER = UUID.fromString("de0e83e8-d7ff-11eb-b8bc-0242ac130002");
    public int arcanaConsumed;
    public float weakenedDamageValue;

    public ItemArcanaPoweredSword(String name, IItemTier tier, int arcanaConsumed, float weakenedDamageValue) {
        super(name, RarityList.COMMON, tier, DivineRPG.tabs.melee);
        this.arcanaConsumed = arcanaConsumed;
        this.weakenedDamageValue = weakenedDamageValue;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(ATTACK_MODIFIER, "Weapon attack", (double)weakenedDamageValue, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        Arcana arcana = (Arcana)player.getCapability(ArcanaCapability.CAPABILITY_ARCANA).orElse(null);
        if (!player.field_70170_p.field_72995_K && entity instanceof LivingEntity && arcana.getArcana() >= (float)this.arcanaConsumed) {
            arcana.consume(player, this.arcanaConsumed);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.func_82737_E() % 10L == 0L && entity instanceof LivingEntity) {
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                player.func_233645_dx_().func_233785_a_(this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack));
                player.func_233645_dx_().func_233793_b_(this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack));
            } else {
                LivingEntity entityLivingBase = (LivingEntity)entity;
                entityLivingBase.func_233645_dx_().func_233785_a_(this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack));
                entityLivingBase.func_233645_dx_().func_233793_b_(this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack));
            }
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        return equipmentSlot == EquipmentSlotType.OFFHAND ? this.attributeModifiers : super.getAttributeModifiers(equipmentSlot, stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumed));
        tooltip.add(LocalizeUtils.weakenedWithoutArcana());
    }
}

