/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.DivineRPG;
import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaCapability;
import divinerpg.entities.projectile.EntityMerikMissile;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemMeriksMissile
extends ItemMod {
    public static final int MAX_USE_DURATION = 72000;

    public ItemMeriksMissile(String name) {
        super(name, new Item.Properties().func_200916_a(DivineRPG.tabs.ranged).func_200917_a(1).func_200918_c(-1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity livingEntity, int timeLeft) {
        if (stack.func_77973_b() == ItemRegistry.meriksMissile && livingEntity instanceof PlayerEntity) {
            float charge = (float)(72000 - timeLeft) / 20.0f;
            PlayerEntity player = (PlayerEntity)livingEntity;
            Arcana arcana = (Arcana)player.getCapability(ArcanaCapability.CAPABILITY_ARCANA).orElse(null);
            if ((double)charge > 1.0) {
                charge = 1.0f;
            }
            float arcanaPoints = 50.0f * charge;
            if (arcana.getArcana() >= arcanaPoints && !world.field_72995_K) {
                if (charge < 0.2f) {
                    return;
                }
                float damage = MathHelper.func_76131_a((float)(charge * 25.0f), (float)8.0f, (float)25.0f);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187737_v, SoundCategory.MASTER, 1.0f, 1.0f);
                EntityMerikMissile bullet = new EntityMerikMissile(EntityRegistry.MERIKS_MISSILE, world, (LivingEntity)player, damage);
                bullet.func_225653_b_(player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_());
                bullet.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 1.0f);
                world.func_217376_c((Entity)bullet);
                arcana.consume(player, arcanaPoints);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("tooltip.meriks_missile", new Object[0]));
        tooltip.add(LocalizeUtils.bowDam("8-25"));
        tooltip.add(LocalizeUtils.arcanaConsumed("10-50"));
        tooltip.add(LocalizeUtils.infiniteUses());
    }
}

