/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.entities.projectile.EntityStar;
import divinerpg.enums.BulletType;
import divinerpg.items.base.ItemModRanged;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.RarityList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemStaffStarlight
extends ItemModRanged {
    private final int count;
    private final ITextComponent starsInfo;

    public ItemStaffStarlight(String name, int arcana, int count) {
        super(name, RarityList.COMMON, EntityRegistry.STARLIGHT, null, SoundRegistry.STARLIGHT, SoundCategory.MASTER, -1, 0, null, arcana);
        this.count = count;
        this.starsInfo = LocalizeUtils.i18n(count > 1 ? "tooltip.staff_of_starlight" : "tooltip.starlight", new Object[0]);
    }

    protected void spawnEntity(World world, PlayerEntity player, ItemStack stack, BulletType bulletType, EntityType entityType) {
        int blockReachDistance = 32;
        Vector3d vec3d = player.func_174824_e(1.0f);
        Vector3d vec3d1 = player.func_70676_i(1.0f);
        Vector3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)blockReachDistance, vec3d1.field_72448_b * (double)blockReachDistance, vec3d1.field_72449_c * (double)blockReachDistance);
        BlockRayTraceResult pos = player.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (!world.field_72995_K) {
            for (int i = 0; i < this.count; ++i) {
                EntityStar star = new EntityStar(EntityRegistry.STARLIGHT, (double)pos.func_216350_a().func_177958_n() + 0.5, (double)pos.func_216350_a().func_177956_o() + 25.0, (double)pos.func_216350_a().func_177952_p() + 0.5, world);
                star.func_225653_b_(pos.func_216350_a().func_177958_n(), pos.func_216350_a().func_177956_o() + 20, pos.func_216350_a().func_177952_p());
                world.func_217376_c((Entity)star);
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.rangedDam(20.0));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.starsInfo);
    }
}

