/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.DivineRPG;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.KeyRegistry;
import divinerpg.util.RarityList;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.server.command.TextComponentHelper;

public class ItemBossSpawner
extends ItemMod {
    private RegistryKey<World> dimensionID;
    private final EntityType[] ents;
    private final String langKey;

    public ItemBossSpawner(String name, String langKey, RegistryKey<World> dimensionID, EntityType<?> ... ents) {
        super(name, new Item.Properties().func_200916_a(DivineRPG.tabs.spawners).func_200917_a(1).func_208103_a(RarityList.BOSS));
        this.dimensionID = dimensionID;
        this.ents = ents;
        this.langKey = langKey;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            if (this.dimensionID == null) {
                this.dimensionID = KeyRegistry.MORTUM_WORLD;
            }
            if (world.func_234923_W_() != this.dimensionID) {
                TextComponent message = TextComponentHelper.createComponentTranslation((ICommandSource)player, (String)this.langKey, (Object[])new Object[0]);
                message.func_240699_a_(TextFormatting.AQUA);
                player.func_145747_a((ITextComponent)message, player.func_110124_au());
                return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
            }
            if (world.func_175659_aa() == Difficulty.PEACEFUL) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.spawner.peaceful"), player.func_110124_au());
                return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
            }
            for (EntityType entType : this.ents) {
                Entity entity = entType.func_200721_a(world);
                entity.func_225653_b_(player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_());
                world.func_217376_c(entity);
                DivineRPG.LOGGER.info("spawned " + entType.func_210760_d() + " at " + entity.func_233580_cy_());
                if (player.func_184812_l_()) continue;
                player.func_184586_b(hand).func_190918_g(1);
            }
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
    }
}

