/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.DivineRPG;
import divinerpg.entities.projectile.EntityDivineArrow;
import divinerpg.enums.ArrowType;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemModBow
extends BowItem {
    private SoundEvent shootSound = SoundEvents.field_187737_v;
    public static final int DEFAULT_MAX_USE_DURATION = 72000;
    protected ArrowType arrowType;
    protected int maxUseDuration;
    protected boolean unbreakable;
    protected Supplier<Item> arrowSupplier;

    public ItemModBow(String name, Rarity rarity, ArrowType arrowType, int uses, Supplier<Item> arrowSupplier) {
        this(name, rarity, arrowType, uses, 72000, arrowSupplier);
    }

    public ItemModBow(String name, ArrowType arrowType, int uses, Supplier<Item> arrowSupplier, Item.Properties properties) {
        this(name, arrowType, uses, 72000, arrowSupplier, properties);
    }

    public ItemModBow(String name, Rarity rarity, ArrowType arrowType, int uses) {
        this(name, rarity, arrowType, uses, 72000, () -> null);
    }

    public ItemModBow(String name, Rarity rarity, ArrowType arrowType, int uses, int maxUseDuration) {
        this(name, rarity, arrowType, uses, maxUseDuration, () -> null);
    }

    public ItemModBow(String name, Rarity rarity, ArrowType arrowType, int uses, int maxUseDuration, Supplier<Item> arrowSupplier) {
        super(new Item.Properties().func_200916_a(DivineRPG.tabs.ranged).func_200918_c(uses).func_208103_a(rarity));
        this.setRegistryName("divinerpg", name);
        this.arrowType = arrowType;
        this.arrowSupplier = arrowSupplier;
        this.maxUseDuration = maxUseDuration;
        this.unbreakable = true;
    }

    public ItemModBow(String name, ArrowType arrowType, int uses, int maxUseDuration, Supplier<Item> arrowSupplier, Item.Properties properties) {
        super(properties);
        this.setRegistryName("divinerpg", name);
        this.arrowType = arrowType;
        this.arrowSupplier = arrowSupplier;
        this.maxUseDuration = maxUseDuration;
        this.unbreakable = true;
    }

    public int func_230305_d_() {
        return (int)((float)super.func_230305_d_() + this.arrowType.getMaxDamage());
    }

    public int func_77626_a(ItemStack stack) {
        return this.maxUseDuration;
    }

    private Item getArrowItem() {
        return this.arrowSupplier.get();
    }

    private boolean needsArrow() {
        return this.arrowSupplier.get() != null;
    }

    public AbstractArrowEntity customArrow(AbstractArrowEntity arrow) {
        return new EntityDivineArrow(EntityRegistry.ARROW_SHOT, arrow.field_70170_p, this.arrowType, arrow.field_70169_q, arrow.field_70167_r, arrow.field_70166_s);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.bowDam(this.arrowType.getMinDamage() + "-" + this.arrowType.getMaxDamage()));
        double speed = 72000.0 / (double)this.func_77626_a(stack);
        if (speed > 1.0) {
            tooltip.add(LocalizeUtils.i18n("tooltip.bow_speed.faster", String.format("%s", speed)));
        }
        if (speed < 1.0) {
            tooltip.add(LocalizeUtils.i18n("tooltip.bow_speed.slower", String.format("%s", 1.0 / speed)));
        }
        tooltip.add(!this.unbreakable ? LocalizeUtils.usesRemaining(stack.func_77958_k() - stack.func_77952_i()) : LocalizeUtils.infiniteUses());
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.POSION) {
            tooltip.add(LocalizeUtils.poison(2.0f));
        }
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.FLAME) {
            tooltip.add(LocalizeUtils.burn(12));
        }
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.EXPLODE) {
            tooltip.add(LocalizeUtils.explosiveShots());
        }
        tooltip.add(this.needsArrow() ? LocalizeUtils.ammo(this.getArrowItem()) : LocalizeUtils.infiniteAmmo());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean hasAmmo;
        ItemStack itemstack = player.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)world, (PlayerEntity)player, (Hand)hand, (boolean)(hasAmmo = !this.needsArrow() || !this.findAmmunition(player).func_190926_b()));
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !hasAmmo) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            float f;
            PlayerEntity entityplayer = (PlayerEntity)entityLiving;
            boolean infiniteAmmo = !this.needsArrow() || entityplayer.func_184812_l_() || EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185312_x, (LivingEntity)entityLiving) > 0;
            ItemStack itemstack = this.findAmmunition(entityplayer);
            int charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)entityplayer, (int)(this.maxUseDuration - timeLeft), (!itemstack.func_190926_b() || infiniteAmmo ? 1 : 0) != 0);
            if (charge < 0) {
                return;
            }
            if ((!itemstack.func_190926_b() || infiniteAmmo) && (double)(f = this.getScaledArrowVelocity(charge)) >= 0.1) {
                if (!worldIn.field_72995_K) {
                    int k;
                    int j;
                    EntityDivineArrow entityarrow = new EntityDivineArrow(EntityRegistry.ARROW_SHOT, worldIn, this.arrowType, (LivingEntity)entityplayer);
                    entityarrow.setAmmoItem(this.getArrowItem(), infiniteAmmo);
                    entityarrow.func_234612_a_((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    if (f == 1.0f) {
                        entityarrow.setIsCritical(true);
                    }
                    if ((j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (LivingEntity)entityLiving)) > 0) {
                        entityarrow.setDamage(entityarrow.getDamage() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (LivingEntity)entityLiving)) > 0) {
                        entityarrow.func_70240_a(k);
                    }
                    if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (LivingEntity)entityLiving) > 0) {
                        entityarrow.func_70015_d(100);
                    }
                    if (!this.unbreakable) {
                        stack.func_222118_a(1, (LivingEntity)entityplayer, p_220009_1_ -> p_220009_1_.func_213334_d(entityplayer.func_184600_cs()));
                    }
                    worldIn.func_217376_c((Entity)entityarrow);
                }
                worldIn.func_184148_a(null, entityplayer.field_70169_q, entityplayer.field_70167_r, entityplayer.field_70166_s, this.shootSound, SoundCategory.MASTER, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!infiniteAmmo) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        entityplayer.field_71071_by.func_184437_d(itemstack);
                    }
                }
                entityplayer.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
        }
    }

    public float getScaledArrowVelocity(int charge) {
        float timeRatio = 72000.0f / (float)this.maxUseDuration;
        float f = (float)charge / 20.0f * timeRatio;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    protected boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() == this.getArrowItem();
    }

    private ItemStack findAmmunition(PlayerEntity player) {
        if (this.isArrow(player.func_184586_b(Hand.OFF_HAND))) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(Hand.MAIN_HAND))) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemStackLimit(stack) == 1 && (stack.func_77958_k() < 0 || this.getItemStackLimit(stack) == 1);
    }

    public ItemModBow setSound(SoundEvent shootSound) {
        this.shootSound = shootSound;
        return this;
    }
}

