/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.DivineRPG;
import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaCapability;
import divinerpg.entities.projectile.EntityColoredBullet;
import divinerpg.entities.projectile.EntityParticleBullet;
import divinerpg.entities.projectile.EntityShooterBullet;
import divinerpg.enums.BulletType;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemModRanged
extends ItemMod {
    private final EntityType<?> entityType;
    private final SoundEvent sound;
    private final SoundCategory soundCategory;
    private final int delay;
    private final Supplier<Item> ammoSupplier;
    private int arcanaConsuming;
    private final String delayTagName = "CanShootTime";
    protected BulletType bulletType;

    public ItemModRanged(String name, Rarity rarity, EntityType<?> entityType, BulletType bulletType, SoundEvent sound, SoundCategory soundCategory, int maxDamage, int delay, Supplier<Item> ammoSupplier, int arcanaConsuming) {
        super(name, new Item.Properties().func_200916_a(DivineRPG.tabs.ranged).func_200918_c(maxDamage).func_208103_a(rarity));
        this.entityType = entityType;
        this.sound = sound;
        this.soundCategory = soundCategory;
        this.delay = delay;
        this.ammoSupplier = ammoSupplier == null ? () -> null : ammoSupplier;
        this.arcanaConsuming = arcanaConsuming;
        this.bulletType = bulletType;
    }

    public ItemModRanged(String name, EntityType<?> entityType, BulletType bulletType, SoundEvent sound, SoundCategory soundCategory, int maxDamage, int delay, Supplier<Item> ammoSupplier, int arcanaConsuming, ItemGroup tab) {
        super(name, new Item.Properties().func_200916_a(tab).func_200918_c(maxDamage));
        this.entityType = entityType;
        this.sound = sound;
        this.soundCategory = soundCategory;
        this.delay = delay;
        this.ammoSupplier = ammoSupplier == null ? () -> null : ammoSupplier;
        this.arcanaConsuming = arcanaConsuming;
        this.bulletType = bulletType;
    }

    public ItemModRanged(String name, Rarity rarity, BulletType bulletType, SoundEvent shotSound, Supplier<Item> ammoSupplier, int maxDamange, int counter) {
        this(name, rarity, null, bulletType, shotSound, SoundCategory.MASTER, maxDamange, counter, ammoSupplier, 0);
    }

    public ItemModRanged(String name, Rarity rarity, BulletType bulletType, SoundEvent shotSound, int uses, int counter) {
        this(name, rarity, bulletType, shotSound, () -> null, uses, counter);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.bulletType != null) {
            tooltip.add(LocalizeUtils.rangedDam(this.bulletType.getDamage()));
        }
        if (!this.needsAmmo()) {
            tooltip.add(LocalizeUtils.i18n("tooltip.ammo.infinite", new Object[0]));
        } else {
            ItemStack ammo = new ItemStack((IItemProvider)this.ammoSupplier.get());
            tooltip.add(LocalizeUtils.ammo(this.getAmmo(), ammo != null));
        }
        tooltip.add(stack.func_77958_k() == -1 ? LocalizeUtils.infiniteUses() : LocalizeUtils.usesRemaining(stack.func_77958_k() - stack.func_77952_i()));
        if (this.arcanaConsuming > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsuming));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ActionResultType result = ActionResultType.FAIL;
        if (this.canUseRangedWeapon(player, stack)) {
            ActionResult<ItemStack> ammo = this.tryFindAmmo(player);
            ActionResult<Arcana> checkArcana = this.tryCheckArcana(player);
            if (ammo.func_188397_a() == ActionResultType.SUCCESS && checkArcana.func_188397_a() == ActionResultType.SUCCESS) {
                ItemStack ammoStack;
                Arcana arcana;
                this.doPreUsageEffects(world, player);
                if (!world.field_72995_K) {
                    world.func_184133_a(null, player.func_233580_cy_(), this.sound != null ? this.sound : SoundEvents.field_187737_v, this.soundCategory != null ? this.soundCategory : SoundCategory.MASTER, 1.0f, 1.0f);
                    this.spawnEntity(world, player, stack, this.bulletType, this.entityType);
                }
                if ((arcana = (Arcana)checkArcana.func_188398_b()) != null) {
                    arcana.consume(player, this.arcanaConsuming);
                }
                if ((ammoStack = (ItemStack)ammo.func_188398_b()) != null) {
                    ammoStack.func_190918_g(1);
                }
                if (!player.func_184812_l_()) {
                    stack.func_222118_a(1, (LivingEntity)player, p_220009_1_ -> p_220009_1_.func_213334_d(player.func_184600_cs()));
                }
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.delay * 4 + 1);
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
                }
                this.doPostUsageEffects(world, player);
            }
        }
        return new ActionResult(result, (Object)stack);
    }

    private Item getAmmo() {
        return this.ammoSupplier.get();
    }

    private boolean needsAmmo() {
        return this.ammoSupplier.get() != null;
    }

    private boolean isAmmo(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() == this.getAmmo();
    }

    private ItemStack findAmmo(PlayerEntity player) {
        if (this.isAmmo(player.func_184586_b(Hand.OFF_HAND))) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(Hand.MAIN_HAND))) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected ActionResult<ItemStack> tryFindAmmo(PlayerEntity player) {
        ItemStack stack = null;
        ActionResultType result = ActionResultType.SUCCESS;
        if (!player.func_184812_l_() && this.needsAmmo() && ((stack = this.findAmmo(player)) == null || stack.func_190916_E() < 1)) {
            result = ActionResultType.FAIL;
        }
        return new ActionResult(result, stack);
    }

    protected ActionResult<Arcana> tryCheckArcana(PlayerEntity player) {
        Arcana arcana = null;
        ActionResultType result = ActionResultType.SUCCESS;
        if (!player.func_184812_l_() && this.arcanaConsuming > 0 && ((arcana = (Arcana)player.getCapability(ArcanaCapability.CAPABILITY_ARCANA).orElse(null)) == null || arcana.getArcana() < (float)this.arcanaConsuming)) {
            result = ActionResultType.FAIL;
        }
        return new ActionResult(result, arcana);
    }

    protected boolean canUseRangedWeapon(PlayerEntity player, ItemStack stack) {
        return player.func_184812_l_() || stack.func_77958_k() <= 0 || stack.func_77952_i() < stack.func_77958_k();
    }

    protected void spawnEntity(World world, PlayerEntity player, ItemStack stack, BulletType bulletType, EntityType<?> entityType) {
        ThrowableEntity bullet = null;
        if (entityType != null) {
            try {
                bullet = (ThrowableEntity)entityType.func_200721_a(world);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        } else {
            bullet = bulletType.getParticle() != ParticleTypes.field_197612_e ? new EntityParticleBullet(EntityRegistry.PARTICLE_BULLET, world, (LivingEntity)player, bulletType) : (bulletType.getColor() != null ? new EntityColoredBullet(EntityRegistry.COLORED_BULLET, (LivingEntity)player, world, bulletType) : new EntityShooterBullet(EntityRegistry.SHOOTER_BULLET, (LivingEntity)player, world, bulletType));
        }
        bullet.func_225653_b_(player.field_70169_q, player.func_226280_cw_(), player.field_70166_s);
        bullet.func_212361_a((Entity)player);
        bullet.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 0.5f);
        world.func_217376_c((Entity)bullet);
    }

    protected void doPreUsageEffects(World world, PlayerEntity player) {
    }

    protected void doPostUsageEffects(World world, PlayerEntity player) {
    }
}

