/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import divinerpg.util.LocalizeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModSword
extends SwordItem {
    public ItemModSword(String name, Rarity rarity, IItemTier tier, ItemGroup group) {
        super(tier, 1, 1.0f, new Item.Properties().func_200916_a(group).func_208103_a(rarity));
        this.setRegistryName("divinerpg", name);
    }

    public ItemModSword(String name, IItemTier tier, Item.Properties properties) {
        super(tier, 1, 1.0f, properties);
        this.setRegistryName("divinerpg", name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addAdditionalInformation(tooltip);
        if (this.func_77612_l() == -1) {
            tooltip.add(LocalizeUtils.infiniteUses());
        }
    }

    protected void addAdditionalInformation(List<ITextComponent> list) {
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ArrayListMultimap modifiers = ArrayListMultimap.create((Multimap)super.getAttributeModifiers(slot, stack));
        if (slot == EquipmentSlotType.MAINHAND) {
            this.replaceModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.field_233825_h_, field_185050_h, this.func_200891_e().func_200928_b());
        }
        return ImmutableMultimap.copyOf((Multimap)modifiers);
    }

    private void replaceModifier(Multimap<Attribute, AttributeModifier> modifierMultimap, Attribute attribute, UUID id, double multiplier) {
        Collection modifiers = modifierMultimap.get((Object)attribute);
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        modifierOptional.ifPresent(modifier -> {
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() * multiplier, modifier.func_220375_c()));
        });
    }
}

