/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import divinerpg.DivineRPG;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InfusionTableRecipe
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    public final ItemStack input;
    public final ItemStack template;
    public final ItemStack output;
    public final int count;
    private final ResourceLocation id;

    public InfusionTableRecipe(ResourceLocation id, ItemStack input, ItemStack template, ItemStack output, int count) {
        this.id = id;
        this.input = input;
        this.template = template;
        this.output = output;
        this.count = count;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return ItemStack.func_179545_c((ItemStack)this.input, (ItemStack)inv.func_70301_a(0)) && ItemStack.func_179545_c((ItemStack)this.template, (ItemStack)inv.func_70301_a(1)) && inv.func_70301_a(0).func_190916_E() == this.count;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int p_194133_1_, int p_194133_2_) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public NonNullList<Ingredient> getTemplate() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.input}));
        return ingredients;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public int getCount() {
        return this.count;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return DivineRPG.INFUSION_TABLE_RECIPE;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfusionTableRecipe> {
        int count = 1;

        Serializer() {
            this.setRegistryName(new ResourceLocation("divinerpg", "infusion_table"));
        }

        public InfusionTableRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack input;
            if (json.get("input").isJsonObject()) {
                input = ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("input"));
            } else {
                ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"input"));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null) {
                    throw new JsonSyntaxException("Unknown item '" + id + "'");
                }
                this.count = !json.has("count") ? 1 : JSONUtils.func_151203_m((JsonObject)json, (String)"count");
                input = new ItemStack((IItemProvider)item, this.count);
            }
            ItemStack template = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"template"), (boolean)false);
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)false);
            return new InfusionTableRecipe(recipeId, input, template, output, input.func_190916_E());
        }

        @Nullable
        public InfusionTableRecipe fromNetwork(ResourceLocation resourceLocation, PacketBuffer buffer) {
            ItemStack input = buffer.func_150791_c();
            ItemStack template = buffer.func_150791_c();
            ItemStack output = buffer.func_150791_c();
            int count = buffer.readInt();
            return new InfusionTableRecipe(resourceLocation, input, template, output, count);
        }

        public void toNetwork(PacketBuffer buffer, InfusionTableRecipe recipe) {
            buffer.func_150788_a(recipe.input);
            buffer.func_150788_a(recipe.template);
            buffer.func_150788_a(recipe.output);
            buffer.writeInt(recipe.count);
        }
    }
}

