/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import com.mojang.serialization.Codec;
import divinerpg.DivineRPG;
import divinerpg.config.Config;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ConfiguredStructureRegistry;
import divinerpg.registries.DecoratorRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.KeyRegistry;
import divinerpg.world.gen.tree.feature.ApalachiaTreeFeature;
import divinerpg.world.gen.tree.feature.DivineTreeFeature;
import divinerpg.world.gen.tree.feature.EdenTreeFeature;
import divinerpg.world.gen.tree.feature.FrozenTreeFeature;
import divinerpg.world.gen.tree.feature.MortumPlants;
import divinerpg.world.gen.tree.feature.MortumTreeFeature;
import divinerpg.world.gen.tree.feature.SkythernTreeFeature;
import divinerpg.world.gen.tree.feature.WildwoodTreeFeature;
import divinerpg.world.placement.TarLake;
import divinerpg.world.placement.VetheaPillars;
import divinerpg.world.vethea.FireCrystalFeature;
import divinerpg.world.vethea.VetheaPillarFeature;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="divinerpg")
public class FeatureRegistry {
    private static final ArrayList<ConfiguredFeature<?, ?>> overworldOres = new ArrayList();
    private static final ArrayList<ConfiguredFeature<?, ?>> netherOres = new ArrayList();
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"divinerpg");
    public static final RegistryObject<DivineTreeFeature> EDEN_TREE = FeatureRegistry.register("eden_tree", () -> new EdenTreeFeature(() -> BlockRegistry.edenSapling));
    public static final RegistryObject<DivineTreeFeature> WILDWOOD_TREE = FeatureRegistry.register("wildwood_tree", () -> new WildwoodTreeFeature(() -> BlockRegistry.wildwoodSapling));
    public static final RegistryObject<DivineTreeFeature> APALACHIA_TREE = FeatureRegistry.register("apalachia_tree", () -> new ApalachiaTreeFeature(() -> BlockRegistry.apalachiaSapling));
    public static final RegistryObject<DivineTreeFeature> SKYTHERN_TREE = FeatureRegistry.register("skythern_tree", () -> new SkythernTreeFeature(() -> BlockRegistry.skythernSapling));
    public static final RegistryObject<DivineTreeFeature> MORTUM_TREE = FeatureRegistry.register("mortum_tree", () -> new MortumTreeFeature(() -> BlockRegistry.mortumSapling));
    public static final RegistryObject<DivineTreeFeature> FROZEN_TREE = FeatureRegistry.register("frozen_tree", () -> new FrozenTreeFeature(() -> BlockRegistry.frozenSapling));
    public static final RegistryObject<MortumPlants> MORTUM_BRUSH = FeatureRegistry.register("mortum_plants", () -> new MortumPlants((Codec<BlockStateProvidingFeatureConfig>)BlockStateProvidingFeatureConfig.field_236453_a_));
    public static final RegistryObject<VetheaPillarFeature> VETHEA_PILLAR = FeatureRegistry.register("vethea_pillar", () -> new VetheaPillarFeature((Codec<BlockStateFeatureConfig>)BlockStateFeatureConfig.field_236455_a_, 32));
    public static final RegistryObject<FireCrystalFeature> FIRE_CRYSTAL = FeatureRegistry.register("fire_crystal", () -> new FireCrystalFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static ConfiguredFeature<?, ?> TAR_LAKE_CONFIGURED;
    public static ConfiguredFeature<?, ?> VETHEA_PILLAR_CONFIGURED;
    public static ConfiguredFeature<?, ?> FIRE_CRYSTAL_CONFIGURED;

    public static void register() {
        DivineRPG.LOGGER.info("[DivineRPG] Registered features");
        overworldOres.add(FeatureRegistry.register("arlemite_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, BlockRegistry.arlemiteOre.func_176223_P(), ((Integer)Config.arlemiteVeinSize.get()).intValue())).func_242733_d(((Integer)Config.arlemiteMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)Config.arlemiteTries.get()).intValue())));
        overworldOres.add(FeatureRegistry.register("realmite_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, BlockRegistry.realmiteOre.func_176223_P(), ((Integer)Config.realmiteVeinSize.get()).intValue())).func_242733_d(((Integer)Config.realmiteMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)Config.realmiteTries.get()).intValue())));
        overworldOres.add(FeatureRegistry.register("rupee_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, BlockRegistry.rupeeOre.func_176223_P(), ((Integer)Config.rupeeVeinSize.get()).intValue())).func_242733_d(((Integer)Config.rupeeMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)Config.rupeeTries.get()).intValue())));
        netherOres.add(FeatureRegistry.register("bloodgem_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, BlockRegistry.bloodgemOre.func_176223_P(), ((Integer)Config.netherVein.get()).intValue())).func_242733_d(256)).func_242728_a()).func_242731_b(((Integer)Config.netherTries.get()).intValue())));
        netherOres.add(FeatureRegistry.register("torridite_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, BlockRegistry.torriditeOre.func_176223_P(), ((Integer)Config.netherVein.get()).intValue())).func_242733_d(256)).func_242728_a()).func_242731_b(((Integer)Config.netherTries.get()).intValue())));
        Registry registry = WorldGenRegistries.field_243653_e;
        TAR_LAKE_CONFIGURED = Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(BlockRegistry.smolderingTar.func_176223_P())).func_227228_a_(((TarLake)DecoratorRegistry.TAR_LAKE.get()).func_227446_a_((IPlacementConfig)new ChanceConfig(5)));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("divinerpg", "tar_lake"), TAR_LAKE_CONFIGURED);
        VETHEA_PILLAR_CONFIGURED = ((ConfiguredFeature)((VetheaPillarFeature)VETHEA_PILLAR.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(BlockRegistry.dreamStone.func_176223_P())).func_242731_b(32)).func_227228_a_(((VetheaPillars)DecoratorRegistry.VETHEA_PILLARS.get()).func_227446_a_((IPlacementConfig)new ChanceConfig(400000)));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("divinerpg", "vethea_pillar"), VETHEA_PILLAR_CONFIGURED);
        FIRE_CRYSTAL_CONFIGURED = (ConfiguredFeature)((ConfiguredFeature)((FireCrystalFeature)FIRE_CRYSTAL.get()).func_225566_b_((IFeatureConfig)new NoFeatureConfig()).func_242729_a(500)).func_242731_b(32);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("divinerpg", "fire_crystal"), FIRE_CRYSTAL_CONFIGURED);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void gen(BiomeLoadingEvent event) {
        ResourceLocation biome = event.getName();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        Biome.Category eventCategory = event.getCategory();
        if (biome == null) {
            return;
        }
        if (eventCategory.equals((Object)Biome.Category.NETHER)) {
            for (ConfiguredFeature<?, ?> ore : netherOres) {
                if (ore == null) continue;
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ore);
            }
        }
        for (ConfiguredFeature<?, ?> ore : overworldOres) {
            if (ore == null) continue;
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ore);
        }
        if (!(eventCategory.equals((Object)Biome.Category.NETHER) || eventCategory.equals((Object)Biome.Category.THEEND) || eventCategory.equals((Object)Biome.Category.RIVER) || eventCategory.equals((Object)Biome.Category.OCEAN) || eventCategory.equals((Object)Biome.Category.BEACH))) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)KeyRegistry.DIVINE_TREE.func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(75))).func_242731_b(1));
            if (!(eventCategory.equals((Object)Biome.Category.JUNGLE) || eventCategory.equals((Object)Biome.Category.SWAMP) || eventCategory.equals((Object)Biome.Category.MUSHROOM))) {
                generation.func_242513_a(GenerationStage.Decoration.LAKES, (ConfiguredFeature)TAR_LAKE_CONFIGURED.func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(50))).func_242731_b(1));
            }
        }
        if (eventCategory.equals((Object)Biome.Category.PLAINS)) {
            generation.func_242516_a(ConfiguredStructureRegistry.CONFIGURED_HUT);
        }
        EntityRegistry.spawnStuff(event);
    }

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)("divinerpg:" + name), configuredFeature);
    }

    private static <C extends IFeatureConfig, F extends Feature<C>> RegistryObject<F> register(String id, Supplier<F> feature) {
        return FEATURES.register(id, feature);
    }
}

