/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import divinerpg.DivineRPG;
import divinerpg.config.Config;
import divinerpg.registries.BlockRegistry;
import divinerpg.world.arcana.ArcanaChunkGenerator;
import divinerpg.world.arcana.DivineStructureBlockProcessor;
import divinerpg.world.gen.tree.decorator.WildwoodVineLeavesDecorator;
import divinerpg.world.gen.tree.decorator.WildwoodVineTrunkDecorator;
import divinerpg.world.vethea.VetheaChunkGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class KeyRegistry {
    public static RegistryKey<World> EDEN_WORLD;
    public static RegistryKey<World> WILDWOOD_WORLD;
    public static RegistryKey<World> APALACHIA_WORLD;
    public static RegistryKey<World> SKYTHERN_WORLD;
    public static RegistryKey<World> MORTUM_WORLD;
    public static RegistryKey<World> ARCANA_WORLD;
    public static RegistryKey<World> VETHEA_WORLD;
    public static RegistryKey<World> ICEIKA_WORLD;
    public static RegistryKey<Biome> EDEN_BIOME;
    public static RegistryKey<Biome> WILDWOOD_BIOME;
    public static RegistryKey<Biome> APALACHIA_BIOME;
    public static RegistryKey<Biome> SKYTHERN_BIOME;
    public static RegistryKey<Biome> MORTUM_BIOME;
    public static RegistryKey<Biome> ARCANA_BIOME;
    public static RegistryKey<Biome> VETHEA_BIOME;
    public static RegistryKey<Biome> ICEIKA_PLAINS_BIOME;
    public static RegistryKey<Biome> ICEIKA_HILLS_BIOME;
    public static RegistryKey<SurfaceBuilder<?>> EDEN_BUILDER;
    public static RegistryKey<SurfaceBuilder<?>> WILDWOOD_BUILDER;
    public static RegistryKey<SurfaceBuilder<?>> APALACHIA_BUILDER;
    public static RegistryKey<SurfaceBuilder<?>> SKYTHERN_BUILDER;
    public static RegistryKey<SurfaceBuilder<?>> MORTUM_BUILDER;
    public static RegistryKey<SurfaceBuilder<?>> VETHEA_BUILDER;
    public static RegistryKey<SurfaceBuilder<?>> ICEIKA_BUILDER;
    public static final DeferredRegister<PointOfInterestType> POI;
    public static final RegistryObject<PointOfInterestType> EDEN_PORTAL;
    public static final RegistryObject<PointOfInterestType> WILDWOOD_PORTAL;
    public static final RegistryObject<PointOfInterestType> APALACHIA_PORTAL;
    public static final RegistryObject<PointOfInterestType> SKYTHERN_PORTAL;
    public static final RegistryObject<PointOfInterestType> MORTUM_PORTAL;
    public static final RegistryObject<PointOfInterestType> ICEIKA_PORTAL;
    public static final RegistryObject<PointOfInterestType> ARCANA_PORTAL;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> DIVINE_TREE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> EDEN_TREE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> WILDWOOD_TREE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> APALACHIA_TREE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> SKYTHERN_TREE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> MORTUM_TREE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> FROZEN_TREE;
    public static IStructureProcessorType<DivineStructureBlockProcessor> CHEST_PROCESSOR;

    public static void init() {
        DivineRPG.LOGGER.info("[DivineRPG] Registered registry keys");
        DIVINE_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.divineLog.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.divineLeaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        EDEN_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "eden"));
        EDEN_WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("divinerpg", "eden"));
        EDEN_BUILDER = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239717_r_, (ResourceLocation)new ResourceLocation("divinerpg", "eden"));
        EDEN_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.edenLog.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.edenLeaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        KeyRegistry.register("ore_eden", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new BlockMatchRuleTest(BlockRegistry.twilightStone), BlockRegistry.edenOre.func_176223_P(), ((Integer)Config.twilightVein.get()).intValue())).func_242733_d(256)).func_242728_a()).func_242731_b(((Integer)Config.twilightTries.get()).intValue()));
        WILDWOOD_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "wildwood"));
        WILDWOOD_WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("divinerpg", "wildwood"));
        WILDWOOD_BUILDER = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239717_r_, (ResourceLocation)new ResourceLocation("divinerpg", "wildwood"));
        WILDWOOD_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.wildwoodLog.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.wildwoodLeaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236703_a_((List)ImmutableList.of((Object)((Object)WildwoodVineTrunkDecorator.INSTANCE), (Object)((Object)WildwoodVineLeavesDecorator.INSTANCE))).func_225568_b_());
        KeyRegistry.register("ore_wildwood", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new BlockMatchRuleTest(BlockRegistry.twilightStone), BlockRegistry.wildwoodOre.func_176223_P(), ((Integer)Config.twilightVein.get()).intValue())).func_242733_d(256)).func_242728_a()).func_242731_b(((Integer)Config.twilightTries.get()).intValue()));
        APALACHIA_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "apalachia"));
        APALACHIA_WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("divinerpg", "apalachia"));
        APALACHIA_BUILDER = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239717_r_, (ResourceLocation)new ResourceLocation("divinerpg", "apalachia"));
        APALACHIA_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.apalachiaLog.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.apalachiaLeaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        KeyRegistry.register("ore_apalachia", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new BlockMatchRuleTest(BlockRegistry.twilightStone), BlockRegistry.apalachiaOre.func_176223_P(), ((Integer)Config.twilightVein.get()).intValue())).func_242733_d(256)).func_242728_a()).func_242731_b(((Integer)Config.twilightTries.get()).intValue()));
        SKYTHERN_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "skythern"));
        SKYTHERN_WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("divinerpg", "skythern"));
        SKYTHERN_BUILDER = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239717_r_, (ResourceLocation)new ResourceLocation("divinerpg", "skythern"));
        SKYTHERN_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.skythernLog.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.skythernLeaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        KeyRegistry.register("ore_skythern", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new BlockMatchRuleTest(BlockRegistry.twilightStone), BlockRegistry.skythernOre.func_176223_P(), ((Integer)Config.twilightVein.get()).intValue())).func_242733_d(256)).func_242728_a()).func_242731_b(((Integer)Config.twilightTries.get()).intValue()));
        MORTUM_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "mortum"));
        MORTUM_WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("divinerpg", "mortum"));
        MORTUM_BUILDER = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239717_r_, (ResourceLocation)new ResourceLocation("divinerpg", "mortum"));
        MORTUM_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.mortumLog.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.mortumLeaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        KeyRegistry.register("ore_mortum", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new BlockMatchRuleTest(BlockRegistry.twilightStone), BlockRegistry.mortumOre.func_176223_P(), ((Integer)Config.twilightVein.get()).intValue())).func_242733_d(256)).func_242728_a()).func_242731_b(((Integer)Config.twilightTries.get()).intValue()));
        FROZEN_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.frozenLog.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.brittleLeaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(10, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        ARCANA_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "arcana"));
        ARCANA_WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("divinerpg", "arcana"));
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("divinerpg", "arcana"), ArcanaChunkGenerator.CODEC);
        VETHEA_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "vethea"));
        VETHEA_WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("divinerpg", "vethea"));
        VETHEA_BUILDER = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239717_r_, (ResourceLocation)new ResourceLocation("divinerpg", "vethea"));
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("divinerpg", "vethea"), VetheaChunkGenerator.CODEC);
        ICEIKA_PLAINS_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "iceika_plains"));
        ICEIKA_HILLS_BIOME = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("divinerpg", "iceika_hills"));
        ICEIKA_WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("divinerpg", "iceika"));
        ICEIKA_BUILDER = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239717_r_, (ResourceLocation)new ResourceLocation("divinerpg", "iceika"));
        Registry.func_218322_a((Registry)Registry.field_218364_E, (ResourceLocation)new ResourceLocation("divinerpg", "chest_processor"), CHEST_PROCESSOR);
    }

    private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> feature) {
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("divinerpg", name), feature);
    }

    static {
        POI = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"divinerpg");
        EDEN_PORTAL = POI.register("eden_portal", () -> new PointOfInterestType("eden_portal", (Set)ImmutableSet.copyOf((Collection)BlockRegistry.edenPortal.func_176194_O().func_177619_a()), 0, 1));
        WILDWOOD_PORTAL = POI.register("wildwood_portal", () -> new PointOfInterestType("wildwood_portal", (Set)ImmutableSet.copyOf((Collection)BlockRegistry.wildwoodPortal.func_176194_O().func_177619_a()), 0, 1));
        APALACHIA_PORTAL = POI.register("apalachia_portal", () -> new PointOfInterestType("apalachia_portal", (Set)ImmutableSet.copyOf((Collection)BlockRegistry.apalachiaPortal.func_176194_O().func_177619_a()), 0, 1));
        SKYTHERN_PORTAL = POI.register("skythern_portal", () -> new PointOfInterestType("skythern_portal", (Set)ImmutableSet.copyOf((Collection)BlockRegistry.skythernPortal.func_176194_O().func_177619_a()), 0, 1));
        MORTUM_PORTAL = POI.register("mortum_portal", () -> new PointOfInterestType("mortum_portal", (Set)ImmutableSet.copyOf((Collection)BlockRegistry.mortumPortal.func_176194_O().func_177619_a()), 0, 1));
        ICEIKA_PORTAL = POI.register("iceika_portal", () -> new PointOfInterestType("iceika_portal", (Set)ImmutableSet.copyOf((Collection)BlockRegistry.iceikaPortal.func_176194_O().func_177619_a()), 0, 1));
        ARCANA_PORTAL = POI.register("arcana_portal", () -> new PointOfInterestType("arcana_portal", (Set)ImmutableSet.copyOf((Collection)BlockRegistry.arcanaPortal.func_176194_O().func_177619_a()), 0, 1));
        CHEST_PROCESSOR = () -> DivineStructureBlockProcessor.CODEC;
    }
}

