/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import divinerpg.DivineRPG;
import divinerpg.world.arcana.ArcanaPieces;
import divinerpg.world.gen.piece.ApalachiaPiece;
import divinerpg.world.gen.piece.EdenPiece;
import divinerpg.world.gen.piece.IceikaDungeonPiece;
import divinerpg.world.gen.piece.IceikaHousePiece;
import divinerpg.world.gen.piece.SkythernPiece;
import divinerpg.world.gen.piece.WildwoodPiece;
import divinerpg.world.gen.structure.structures.ApalachiaStructures;
import divinerpg.world.gen.structure.structures.EdenStructures;
import divinerpg.world.gen.structure.structures.HutStructure;
import divinerpg.world.gen.structure.structures.IceikaDungeonStructures;
import divinerpg.world.gen.structure.structures.IceikaStructures;
import divinerpg.world.gen.structure.structures.MortumStructures;
import divinerpg.world.gen.structure.structures.SkythernStructures;
import divinerpg.world.gen.structure.structures.WildwoodStructures;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureRegistry {
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"divinerpg");
    public static final RegistryObject<Structure<NoFeatureConfig>> HUT = DEFERRED_REGISTRY_STRUCTURE.register("hut", () -> new HutStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> EDEN = DEFERRED_REGISTRY_STRUCTURE.register("eden", () -> new EdenStructures((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> WILDWOOD = DEFERRED_REGISTRY_STRUCTURE.register("wildwood", () -> new WildwoodStructures((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> APALACHIA = DEFERRED_REGISTRY_STRUCTURE.register("apalachia", () -> new ApalachiaStructures((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> SKYTHERN = DEFERRED_REGISTRY_STRUCTURE.register("skythern", () -> new SkythernStructures((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MORTUM = DEFERRED_REGISTRY_STRUCTURE.register("mortum", () -> new MortumStructures((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ICEIKA = DEFERRED_REGISTRY_STRUCTURE.register("iceika", () -> new IceikaStructures((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> ICEIKA_DUNGEON = DEFERRED_REGISTRY_STRUCTURE.register("iceika_dungeons", () -> new IceikaDungeonStructures((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        DivineRPG.LOGGER.info("[DivineRPG] Setup structures");
        StructureRegistry.setupMapSpacingAndLand((Structure)HUT.get(), new StructureSeparationSettings(30, 5, 45642069), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)EDEN.get(), new StructureSeparationSettings(30, 5, 45696902), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)WILDWOOD.get(), new StructureSeparationSettings(30, 5, 45611420), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)APALACHIA.get(), new StructureSeparationSettings(30, 5, 6844516), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)SKYTHERN.get(), new StructureSeparationSettings(30, 5, 3213265), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)MORTUM.get(), new StructureSeparationSettings(30, 5, 9784512), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)ICEIKA.get(), new StructureSeparationSettings(30, 5, 3512846), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)ICEIKA_DUNGEON.get(), new StructureSeparationSettings(30, 5, 6845645), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    public static interface Pieces {
        public static final IStructurePieceType ARCANA_PIECE = Pieces.register(ArcanaPieces.Piece::new, "arcana");
        public static final IStructurePieceType ICEIKA_HOUSE = Pieces.register(IceikaHousePiece.Piece::new, "iceika_house");
        public static final IStructurePieceType ICEIKA_DUNGEON = Pieces.register(IceikaDungeonPiece.Piece::new, "iceika_dungeon");
        public static final IStructurePieceType EDEN_PIECE = Pieces.register(EdenPiece.Piece::new, "eden");
        public static final IStructurePieceType WILDWOOD_PIECE = Pieces.register(WildwoodPiece.Piece::new, "wildwood");
        public static final IStructurePieceType APALACHIA_PIECE = Pieces.register(ApalachiaPiece.Piece::new, "apalachia");
        public static final IStructurePieceType SKYTHERN_PIECE = Pieces.register(SkythernPiece.Piece::new, "skythern");

        public static IStructurePieceType register(IStructurePieceType piece, String name) {
            return (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)name.toLowerCase(Locale.ROOT), (Object)piece);
        }
    }
}

