/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.tiles.block;

import divinerpg.blocks.vethea.BlockDreamLamp;
import divinerpg.client.containers.DreamLampContainer;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.TileRegistry;
import divinerpg.util.TileInventoryHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TileEntityDreamLamp
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    public static final int NUMBER_OF_SLOTS = 1;
    private static final String CHESTCONTENTS_INVENTORY_TAG = "contents";
    public final TileInventoryHelper chestContents = TileInventoryHelper.createForTileEntity(1, this::canPlayerAccessInventory, () -> ((TileEntityDreamLamp)this).func_70296_d());
    int ticks;

    public TileEntityDreamLamp() {
        super(TileRegistry.DREAM_LAMP);
    }

    public boolean canPlayerAccessInventory(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double X_CENTRE_OFFSET = 0.5;
        double Y_CENTRE_OFFSET = 0.5;
        double Z_CENTRE_OFFSET = 0.5;
        double MAXIMUM_DISTANCE_SQ = 64.0;
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public CompoundNBT func_189515_b(CompoundNBT parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        CompoundNBT inventoryNBT = this.chestContents.serializeNBT();
        parentNBTTagCompound.func_218657_a(CHESTCONTENTS_INVENTORY_TAG, (INBT)inventoryNBT);
        return parentNBTTagCompound;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT parentNBTTagCompound) {
        super.func_230337_a_(blockState, parentNBTTagCompound);
        CompoundNBT inventoryNBT = parentNBTTagCompound.func_74775_l(CHESTCONTENTS_INVENTORY_TAG);
        this.chestContents.deserializeNBT(inventoryNBT);
        if (this.chestContents.func_70302_i_() != 1) {
            throw new IllegalArgumentException("Corrupted NBT: Number of inventory slots did not match expected.");
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        int tileEntityType = 42;
        return new SUpdateTileEntityPacket(this.field_174879_c, tileEntityType, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_230337_a_(blockState, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTagCompound = new CompoundNBT();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(BlockState blockState, CompoundNBT tag) {
        this.func_230337_a_(blockState, tag);
    }

    public void dropAllContents(World world, BlockPos blockPos) {
        InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)this.chestContents);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(BlockRegistry.dreamLamp.func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity menu) {
        return new DreamLampContainer(windowID, playerInventory, this.chestContents);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack acidStack = this.chestContents.func_70301_a(0);
            boolean powerOn = false;
            if (!acidStack.func_190926_b() && acidStack.func_77973_b() == ItemRegistry.acid) {
                powerOn = true;
            } else if (acidStack.func_190926_b() || acidStack.func_77973_b() != ItemRegistry.acid) {
                powerOn = false;
            }
            Block block = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
            if (block instanceof BlockDreamLamp) {
                if (powerOn) {
                    ((BlockDreamLamp)block).setOn(this.field_145850_b, this.func_174877_v());
                    ++this.ticks;
                    if (this.ticks > 1200) {
                        this.ticks = 0;
                        acidStack.func_190918_g(1);
                    }
                } else {
                    ((BlockDreamLamp)block).setOff(this.field_145850_b, this.func_174877_v());
                }
            }
            this.func_70296_d();
        }
    }
}

