/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.tiles.chests;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public abstract class TileEntityModChest
extends LockableLootTileEntity
implements IChestLid,
ITickableTileEntity {
    public NonNullList<ItemStack> items = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
    public float openness;
    public float oOpenness;
    public int openCount;
    public int tickInterval;
    public String customName;
    private LazyOptional<IItemHandlerModifiable> chestHandler;

    public abstract String getChestName();

    protected TileEntityModChest(TileEntityType<?> p_i48287_1_) {
        super(p_i48287_1_);
    }

    public int func_70302_i_() {
        return 54;
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.func_145818_k_() ? this.customName : this.getChestName());
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.chest");
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(p_230337_2_)) {
            ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.items);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (!this.func_184282_c(p_189515_1_)) {
            ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.items);
        }
        return p_189515_1_;
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.tickInterval;
        this.openCount = TileEntityModChest.getOpenCount(this.field_145850_b, (LockableTileEntity)this, this.tickInterval, i, j, k, this.openCount);
        this.oOpenness = this.openness;
        float f = 0.1f;
        if (this.openCount <= 0 || this.openness == 0.0f) {
            // empty if block
        }
        if (this.openCount == 0 && this.openness > 0.0f || this.openCount > 0 && this.openness < 1.0f) {
            float f1 = this.openness;
            this.openness = this.openCount > 0 ? (this.openness += 0.1f) : (this.openness -= 0.1f);
            if (this.openness > 1.0f) {
                this.openness = 1.0f;
            }
            float f2 = 0.5f;
            if (!(this.openness < 0.5f) || f1 >= 0.5f) {
                // empty if block
            }
            if (this.openness < 0.0f) {
                this.openness = 0.0f;
            }
        }
    }

    public static int getOpenCount(World p_213977_0_, LockableTileEntity p_213977_1_, int p_213977_2_, int p_213977_3_, int p_213977_4_, int p_213977_5_, int p_213977_6_) {
        if (!p_213977_0_.field_72995_K && p_213977_6_ != 0 && (p_213977_2_ + p_213977_3_ + p_213977_4_ + p_213977_5_) % 200 == 0) {
            p_213977_6_ = TileEntityModChest.getOpenCount(p_213977_0_, p_213977_1_, p_213977_3_, p_213977_4_, p_213977_5_);
        }
        return p_213977_6_;
    }

    public static int getOpenCount(World p_213976_0_, LockableTileEntity p_213976_1_, int p_213976_2_, int p_213976_3_, int p_213976_4_) {
        int i = 0;
        float f = 5.0f;
        for (PlayerEntity playerentity : p_213976_0_.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)p_213976_2_ - 5.0f), (double)((float)p_213976_3_ - 5.0f), (double)((float)p_213976_4_ - 5.0f), (double)((float)(p_213976_2_ + 1) + 5.0f), (double)((float)(p_213976_3_ + 1) + 5.0f), (double)((float)(p_213976_4_ + 1) + 5.0f)))) {
            IInventory iinventory;
            if (!(playerentity.field_71070_bA instanceof ChestContainer) || (iinventory = ((ChestContainer)playerentity.field_71070_bA).func_85151_d()) != p_213976_1_ && (!(iinventory instanceof DoubleSidedInventory) || !((DoubleSidedInventory)iinventory).func_90010_a((IInventory)p_213976_1_))) continue;
            ++i;
        }
        return i;
    }

    public boolean func_145842_c(int p_145842_1_, int p_145842_2_) {
        if (p_145842_1_ == 1) {
            this.openCount = p_145842_2_;
            return true;
        }
        return super.func_145842_c(p_145842_1_, p_145842_2_);
    }

    public void func_174889_b(PlayerEntity p_174889_1_) {
        if (!p_174889_1_.func_175149_v()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.signalOpenCount();
        }
    }

    public void func_174886_c(PlayerEntity p_174886_1_) {
        if (!p_174886_1_.func_175149_v()) {
            --this.openCount;
            this.signalOpenCount();
        }
    }

    protected void signalOpenCount() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof ChestBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.openCount);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> p_199721_1_) {
        this.items = p_199721_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float p_195480_1_) {
        return MathHelper.func_219799_g((float)p_195480_1_, (float)this.oOpenness, (float)this.openness);
    }

    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return ChestContainer.func_216992_a((int)p_213906_1_, (PlayerInventory)p_213906_2_, (IInventory)this);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.chestHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.chestHandler;
            this.chestHandler = null;
            oldHandler.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof ChestBlock)) {
            return new InvWrapper((IInventory)this);
        }
        IInventory inv = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)state.func_177230_c()), (BlockState)state, (World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (boolean)true);
        return new InvWrapper((IInventory)(inv == null ? this : inv));
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }
}

