/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.tiles.furnace;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import divinerpg.client.containers.ArcaniumExtractorContainer;
import divinerpg.recipe.ArcaniumExtractorRecipe;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.RecipeRegistry;
import divinerpg.registries.TileRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityArcaniumExtractor
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    protected final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int p_221476_1_) {
            switch (p_221476_1_) {
                case 0: {
                    return TileEntityArcaniumExtractor.this.litTime;
                }
                case 1: {
                    return TileEntityArcaniumExtractor.this.litDuration;
                }
                case 2: {
                    return TileEntityArcaniumExtractor.this.cookingProgress;
                }
                case 3: {
                    return TileEntityArcaniumExtractor.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int p_221477_1_, int p_221477_2_) {
            switch (p_221477_1_) {
                case 0: {
                    TileEntityArcaniumExtractor.this.litTime = p_221477_2_;
                    break;
                }
                case 1: {
                    TileEntityArcaniumExtractor.this.litDuration = p_221477_2_;
                    break;
                }
                case 2: {
                    TileEntityArcaniumExtractor.this.cookingProgress = p_221477_2_;
                    break;
                }
                case 3: {
                    TileEntityArcaniumExtractor.this.cookingTotalTime = p_221477_2_;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected final IRecipeType<? extends ArcaniumExtractorRecipe> recipeType;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public TileEntityArcaniumExtractor() {
        super(TileRegistry.ARCANIUM_EXTRACTOR);
        this.recipeType = RecipeRegistry.RecipeTypes.ARCANIUM_EXTRACTOR_RECIPE_TYPE;
    }

    @Deprecated
    public static Map<Item, Integer> getFuel() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        TileEntityArcaniumExtractor.add(map, (IItemProvider)ItemRegistry.collector, 200);
        return map;
    }

    private static void add(Map<Item, Integer> map, IItemProvider itemProvider, int p_213996_2_) {
        Item item = itemProvider.func_199767_j();
        map.put(item, p_213996_2_);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.items);
        this.litTime = p_230337_2_.func_74762_e("BurnTime");
        this.cookingProgress = p_230337_2_.func_74762_e("CookTime");
        this.cookingTotalTime = p_230337_2_.func_74762_e("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundNBT compoundnbt = p_230337_2_.func_74775_l("RecipesUsed");
        for (String s : compoundnbt.func_150296_c()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundnbt.func_74762_e(s));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        p_189515_1_.func_74768_a("BurnTime", this.litTime);
        p_189515_1_.func_74768_a("CookTime", this.cookingProgress);
        p_189515_1_.func_74768_a("CookTimeTotal", this.cookingTotalTime);
        ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.items);
        CompoundNBT compoundnbt = new CompoundNBT();
        this.recipesUsed.forEach((p_235643_1_, p_235643_2_) -> compoundnbt.func_74768_a(p_235643_1_.toString(), p_235643_2_.intValue()));
        p_189515_1_.func_218657_a("RecipesUsed", (INBT)compoundnbt);
        return p_189515_1_;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.divinerpg.arcanium_extractor");
    }

    protected Container func_213906_a(int i, PlayerInventory playerInventory) {
        return new ArcaniumExtractorContainer(i, playerInventory, (IInventory)this, this.dataAccess);
    }

    protected int getBurnDuration(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != ItemRegistry.collector) {
            return 0;
        }
        return 100;
    }

    public void func_73660_a() {
        boolean flag = this.isLit();
        boolean flag1 = false;
        if (this.isLit()) {
            --this.litTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.items.get(1);
            if (this.isLit() || !itemstack.func_190926_b() && !((ItemStack)this.items.get(0)).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isLit() && this.canBurn(irecipe)) {
                    this.litDuration = this.litTime = this.getBurnDuration(itemstack);
                    if (this.isLit()) {
                        flag1 = true;
                        if (itemstack.hasContainerItem()) {
                            this.items.set(1, (Object)itemstack.getContainerItem());
                        } else if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                this.items.set(1, (Object)itemstack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.isLit() && this.canBurn(irecipe)) {
                    ++this.cookingProgress;
                    if (this.cookingProgress == this.cookingTotalTime) {
                        this.cookingProgress = 0;
                        this.cookingTotalTime = this.getTotalCookTime();
                        this.burn(irecipe);
                        flag1 = true;
                    }
                } else {
                    this.cookingProgress = 0;
                }
            } else if (!this.isLit() && this.cookingProgress > 0) {
                this.cookingProgress = MathHelper.func_76125_a((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    protected boolean canBurn(@Nullable IRecipe<?> iRecipe) {
        if (!((ItemStack)this.items.get(0)).func_190926_b() && iRecipe != null) {
            ItemStack itemstack = iRecipe.func_77571_b();
            if (itemstack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.items.get(2);
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(itemstack)) {
                return false;
            }
            if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
        }
        return false;
    }

    private void burn(@Nullable IRecipe<?> iRecipe) {
        if (iRecipe != null && this.canBurn(iRecipe)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = iRecipe.func_77571_b();
            ItemStack itemstack2 = (ItemStack)this.items.get(2);
            if (itemstack2.func_190926_b()) {
                this.items.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(iRecipe);
            }
            itemstack.func_190918_g(1);
            if (!this.isLit()) {
                ((ItemStack)this.items.get(1)).func_190918_g(1);
            }
        }
    }

    protected int getTotalCookTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(200);
    }

    public int[] func_180463_a(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return direction == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean func_180462_a(int slot, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        Item item;
        return p_180461_3_ != Direction.DOWN || p_180461_1_ != 1 || (item = p_180461_2_.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return ItemStackHelper.func_188382_a(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return ItemStackHelper.func_188383_a(this.items, (int)p_70304_1_);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(slot, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (slot == 0 && !flag) {
            this.cookingTotalTime = this.getTotalCookTime();
            this.cookingProgress = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return TileEntityArcaniumExtractor.getFuel().containsKey(stack.func_77973_b());
    }

    public List<IRecipe<?>> getRecipesToAwardAndPopExperience(World world, Vector3d vector) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            world.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(p_235642_4_ -> {
                list.add(p_235642_4_);
                TileEntityArcaniumExtractor.createExperience(world, vector, entry.getIntValue(), ((ArcaniumExtractorRecipe)((Object)p_235642_4_)).func_222138_b());
            });
        }
        return list;
    }

    private static void createExperience(World world, Vector3d vector3d, int p_235641_2_, float p_235641_3_) {
        int i = MathHelper.func_76141_d((float)((float)p_235641_2_ * p_235641_3_));
        float f = MathHelper.func_226164_h_((float)((float)p_235641_2_ * p_235641_3_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)i);
            i -= j;
            world.func_217376_c((Entity)new ExperienceOrbEntity(world, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, j));
        }
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> p_193056_1_) {
        if (p_193056_1_ != null) {
            ResourceLocation resourcelocation = p_193056_1_.func_199560_c();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_201560_d(PlayerEntity p_201560_1_) {
    }

    public void func_194018_a(RecipeItemHelper p_194018_1_) {
        for (ItemStack itemstack : this.items) {
            p_194018_1_.func_194112_a(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

