/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.tiles.spawner;

import divinerpg.registries.ItemRegistry;
import divinerpg.registries.TileRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;

public class TileEntitySingleUseSpawner
extends TileEntity
implements ITickableTileEntity {
    private EntityType entityId;
    private String entityName;
    private int defaultDelay;
    private int delay;
    private int blockReachDistance;
    private boolean isActivated = false;
    private BlockPos searchRadius = new BlockPos(8, 4, 8);
    private BlockPos baseOffset;

    public TileEntitySingleUseSpawner() {
        super(TileRegistry.SINGLE_SPAWNER);
    }

    public TileEntitySingleUseSpawner(EntityType entityType, int delay, int blockReachDistance, BlockPos baseOffset) {
        super(TileRegistry.SINGLE_SPAWNER);
        this.entityId = entityType;
        this.defaultDelay = delay;
        this.delay = 0;
        this.blockReachDistance = blockReachDistance;
        this.baseOffset = baseOffset;
        this.entityName = entityType.func_210760_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("delay", this.delay);
        compound.func_74772_a("addY", this.baseOffset.func_218275_a());
        compound.func_74757_a("activated", this.isActivated);
        compound.func_74768_a("spawnNearPlayer", this.blockReachDistance);
        compound.func_74778_a("entityID", this.entityId.func_210760_d());
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.delay = compound.func_74762_e("delay");
        this.baseOffset = BlockPos.func_218283_e((long)compound.func_74763_f("addY"));
        this.isActivated = compound.func_74767_n("activated");
        this.blockReachDistance = compound.func_74762_e("spawnNearPlayer");
        this.entityName = compound.func_74779_i("entityId");
    }

    public void func_73660_a() {
        if (!this.isActivated || this.field_145850_b.func_175659_aa() == Difficulty.PEACEFUL || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        Entity entity = this.getRelocatedEntity(this.entityId);
        if (entity != null) {
            this.field_145850_b.func_217376_c(entity);
            this.deactivate();
        }
    }

    public void activate(PlayerEntity player) {
        if (this.isActivated) {
            return;
        }
        this.isActivated = true;
        this.delay = this.defaultDelay;
        if (!this.field_145850_b.field_72995_K && this.delay > 0) {
            if (player.func_184614_ca().func_77973_b() == ItemRegistry.edenChunk) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.divinerpg.sunstorm").func_240699_a_(TextFormatting.YELLOW), player.func_110124_au());
            } else if (player.func_184614_ca().func_77973_b() == ItemRegistry.wildwoodChunk) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.divinerpg.termasect").func_240699_a_(TextFormatting.DARK_BLUE), player.func_110124_au());
            } else if (player.func_184614_ca().func_77973_b() == ItemRegistry.apalachiaChunk) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.divinerpg.eternal_archer").func_240699_a_(TextFormatting.DARK_PURPLE), player.func_110124_au());
            } else if (player.func_184614_ca().func_77973_b() == ItemRegistry.skythernChunk) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.divinerpg.experienced_cori").func_240699_a_(TextFormatting.GRAY), player.func_110124_au());
            }
            player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSource)player, "summon.single_use_spawner.delay", this.delay / 20), player.func_110124_au());
        }
    }

    private void deactivate() {
        this.isActivated = false;
    }

    protected Entity getRelocatedEntity(EntityType entityType) {
        if (entityType != null) {
            Entity e = entityType.func_200721_a(this.field_145850_b);
            BlockPos intialSpawnPosition = this.field_174879_c.func_177981_b(this.searchRadius.func_177956_o() / 2).func_177971_a((Vector3i)this.baseOffset);
            BlockPos blockPos = TileEntitySingleUseSpawner.searchInRadius(this.field_145850_b, intialSpawnPosition, this.searchRadius, x -> {
                e.func_225653_b_((double)x.func_177958_n(), (double)x.func_177956_o(), (double)x.func_177952_p());
                return this.field_145850_b.func_226666_b_(e, e.func_174813_aQ()).isParallel();
            });
            if (blockPos == null) {
                return null;
            }
            e.func_225653_b_((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
            return e;
        }
        return null;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public static BlockPos searchInRadius(World world, BlockPos center, BlockPos range, Predicate<BlockPos> action) {
        int xRadius = 0;
        while ((double)xRadius <= Math.floor((double)range.func_177958_n() / 2.0)) {
            int yRadius = 0;
            while ((double)yRadius <= Math.floor((double)range.func_177956_o() / 2.0)) {
                int zRadius = 0;
                while ((double)zRadius <= Math.floor((double)range.func_177952_p() / 2.0)) {
                    for (int x = -1; x <= 1; x += 2) {
                        for (int y = -1; y <= 1; y += 2) {
                            for (int z = -1; z <= 1; z += 2) {
                                BlockPos pos = center.func_177982_a(x * xRadius, y * yRadius, z * zRadius);
                                if (World.func_189509_E((BlockPos)pos) || !action.test(pos)) continue;
                                return pos;
                            }
                        }
                    }
                    ++zRadius;
                }
                ++yRadius;
            }
            ++xRadius;
        }
        return center;
    }
}

