/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import net.minecraft.command.ICommandSource;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.server.command.TextComponentHelper;

public class LocalizeUtils {
    private static final TextComponent InfiniteUses = new TranslationTextComponent("tooltip.uses.infinite");
    private static final TextComponent NoProtection = new TranslationTextComponent("tooltip.noprotection");
    private static final TextComponent HomingShoots = new TranslationTextComponent("tooltip.shots.homing");
    private static final TextComponent SingleUse = new TranslationTextComponent("tooltip.uses.single");
    private static final TextComponent InstantConsumption = new TranslationTextComponent("tooltip.instant_consumption");
    private static final TextComponent WeakenedWithoutArcana = new TranslationTextComponent("tooltip.weakened_without_arcana");
    private static final String RemainingUses = "tooltip.uses";
    private static final String DamageReductionStringFormat = "tooltip.damage.reduction";
    private static final String Ammo = "tooltip.ammo";
    private static final String ArcanaConsuming = "tooltip.arcana";
    private static final String ArcanaDamageSource = "tooltip.damage.arcana";
    private static final String ArcanaRegen = "tooltip.arcana.regen";
    private static final String MeleeDamage = "tooltip.damage.melee";
    private static final String BowDamage = "tooltip.damage.ranged";
    private static final String RangedAndMeleeDamage = "tooltip.damage.both";
    private static final String Efficency = "tooltip.efficiency";
    private static final String HarvestLevel = "tooltip.harvest_level";
    private static final String Poison = "tooltip.effect.poisons";
    private static final String BurnMobs = "tooltip.effect.burns";
    private static final String SlowMobs = "tooltip.effect.slows";

    public static TextComponent getArmorAbility(String keyPart, Object ... params) {
        String id = String.format("tooltip.armor_info.%s", keyPart);
        return params == null || params.length < 1 ? new TranslationTextComponent(id) : new TranslationTextComponent(id, params);
    }

    public static ITextComponent usesRemaining(int uses) {
        return LocalizeUtils.i18n(RemainingUses, uses);
    }

    public static ITextComponent infiniteAmmo() {
        return LocalizeUtils.i18n("tooltip.ammo.infinite", new Object[0]);
    }

    public static ITextComponent ammo(Item ammo) {
        return LocalizeUtils.ammo(ammo, TextFormatting.GRAY);
    }

    public static ITextComponent ammo(Item ammo, boolean isPresent) {
        return LocalizeUtils.ammo(ammo, isPresent ? TextFormatting.GREEN : TextFormatting.RED);
    }

    public static ITextComponent ammo(Item ammo, TextFormatting formatting) {
        TranslationTextComponent ammoName = new TranslationTextComponent(ammo.func_77658_a());
        ammoName.func_150256_b().func_240721_b_(formatting);
        return LocalizeUtils.i18n(Ammo, ammoName);
    }

    public static ITextComponent arcanaConsumed(Object ar) {
        return LocalizeUtils.i18n(ArcanaConsuming, ar);
    }

    public static ITextComponent arcanaDam(double dam) {
        return LocalizeUtils.i18n(ArcanaDamageSource, dam);
    }

    public static ITextComponent arcanaRegen(int ar) {
        return LocalizeUtils.i18n(ArcanaRegen, ar);
    }

    public static ITextComponent bowDam(String dam) {
        return LocalizeUtils.i18n(BowDamage, dam);
    }

    public static ITextComponent burn(int seconds) {
        return LocalizeUtils.i18n(BurnMobs, seconds);
    }

    public static ITextComponent infiniteUses() {
        return InfiniteUses.func_240699_a_(TextFormatting.BLUE);
    }

    public static ITextComponent instantConsumption() {
        return InstantConsumption.func_240699_a_(TextFormatting.AQUA);
    }

    public static ITextComponent weakenedWithoutArcana() {
        return WeakenedWithoutArcana.func_240699_a_(TextFormatting.RED);
    }

    public static ITextComponent damageReduction(double reduct, double fullReduct) {
        return LocalizeUtils.i18n(DamageReductionStringFormat, reduct, fullReduct);
    }

    public static ITextComponent efficiency(double eff) {
        return LocalizeUtils.i18n(Efficency, eff);
    }

    public static ITextComponent harvestLevel(int lvl) {
        return LocalizeUtils.i18n(HarvestLevel, lvl);
    }

    public static ITextComponent explosiveShots() {
        return LocalizeUtils.i18n("tooltip.shots.explosive", new Object[0]);
    }

    public static ITextComponent homingShots() {
        return HomingShoots;
    }

    public static ITextComponent singleUse() {
        return SingleUse;
    }

    public static ITextComponent meleeDam(double dam) {
        return LocalizeUtils.i18n(MeleeDamage, dam);
    }

    public static ITextComponent poison(float seconds) {
        return LocalizeUtils.i18n(Poison, Float.valueOf(seconds));
    }

    public static ITextComponent rangedDam(double dam) {
        return LocalizeUtils.i18n(BowDamage, dam);
    }

    public static ITextComponent slow(double seconds) {
        return LocalizeUtils.i18n(SlowMobs, seconds);
    }

    public static ITextComponent noProtection() {
        return NoProtection;
    }

    public static String normal(String message) {
        return LocalizeUtils.normal(message, TextFormatting.WHITE);
    }

    public static String normal(String message, TextFormatting format) {
        TranslationTextComponent text = new TranslationTextComponent(message);
        text.func_240699_a_(format);
        return text.func_150261_e();
    }

    public static String version(String vers) {
        TranslationTextComponent text = new TranslationTextComponent("message.version", new Object[]{vers});
        text.func_240699_a_(TextFormatting.RED);
        return text.func_150261_e();
    }

    public static ITextComponent getClientSideTranslation(ICommandSource sender, String str, Object ... args) {
        return TextComponentHelper.createComponentTranslation((ICommandSource)sender, (String)str, (Object[])args);
    }

    public static ITextComponent i18n(String text, Object ... args) {
        TranslationTextComponent result = new TranslationTextComponent(text, args);
        return result.func_240699_a_(TextFormatting.GRAY);
    }

    public static ITextComponent i18n(TextFormatting color, String text, Object ... args) {
        TranslationTextComponent result = new TranslationTextComponent(text, args);
        return result.func_240699_a_(color);
    }
}

