/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.EntitySize;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class PortalShape {
    private static final AbstractBlock.IPositionPredicate FRAME = (p_242966_0_, p_242966_1_, p_242966_2_) -> p_242966_0_.isPortalFrame(p_242966_1_, p_242966_2_);
    private final IWorld level;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private int numPortalBlocks;
    @Nullable
    private BlockPos bottomLeft;
    private int height;
    private int width;
    private static Block portal;
    private static Block frame;

    public Optional<PortalShape> findEmptyPortalShape(IWorld p_242964_0_, BlockPos p_242964_1_, Direction.Axis p_242964_2_) {
        return this.findPortalShape(p_242964_0_, p_242964_1_, p_242968_0_ -> p_242968_0_.isValid() && p_242968_0_.numPortalBlocks == 0, p_242964_2_);
    }

    public Optional<PortalShape> findPortalShape(IWorld p_242965_0_, BlockPos p_242965_1_, Predicate<PortalShape> p_242965_2_, Direction.Axis p_242965_3_) {
        Optional<PortalShape> optional = Optional.of(new PortalShape(p_242965_0_, p_242965_1_, p_242965_3_, portal, frame)).filter(p_242965_2_);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = p_242965_3_ == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new PortalShape(p_242965_0_, p_242965_1_, direction$axis, portal, frame)).filter(p_242965_2_);
    }

    public PortalShape(IWorld world, BlockPos pos, Direction.Axis axis, Block portal, Block frame) {
        this.level = world;
        this.axis = axis;
        this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.bottomLeft = this.calculateBottomLeft(pos);
        if (this.bottomLeft == null) {
            this.bottomLeft = pos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
        PortalShape.portal = portal;
        PortalShape.frame = frame;
    }

    @Nullable
    private BlockPos calculateBottomLeft(BlockPos p_242971_1_) {
        int i = Math.max(0, p_242971_1_.func_177956_o() - 21);
        while (p_242971_1_.func_177956_o() > i && PortalShape.isEmpty(this.level.func_180495_p(p_242971_1_.func_177977_b()))) {
            p_242971_1_ = p_242971_1_.func_177977_b();
        }
        Direction direction = this.rightDir.func_176734_d();
        int j = this.getDistanceUntilEdgeAboveFrame(p_242971_1_, direction) - 1;
        return j < 0 ? null : p_242971_1_.func_177967_a(direction, j);
    }

    private int calculateWidth() {
        int i = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockPos p_242972_1_, Direction p_242972_2_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutable.func_189533_g((Vector3i)p_242972_1_).func_189534_c(p_242972_2_, i);
            BlockState blockstate = this.level.func_180495_p((BlockPos)blockpos$mutable);
            if (!PortalShape.isEmpty(blockstate)) {
                if (!FRAME.test(blockstate, (IBlockReader)this.level, (BlockPos)blockpos$mutable)) break;
                return i;
            }
            BlockState blockstate1 = this.level.func_180495_p((BlockPos)blockpos$mutable.func_189536_c(Direction.DOWN));
            if (!FRAME.test(blockstate1, (IBlockReader)this.level, (BlockPos)blockpos$mutable)) break;
        }
        return 0;
    }

    private int calculateHeight() {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = this.getDistanceUntilTop(blockpos$mutable);
        return i >= 3 && i <= 21 && this.hasTopFrame(blockpos$mutable, i) ? i : 0;
    }

    private boolean hasTopFrame(BlockPos.Mutable p_242970_1_, int p_242970_2_) {
        for (int i = 0; i < this.width; ++i) {
            BlockPos.Mutable blockpos$mutable = p_242970_1_.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, p_242970_2_).func_189534_c(this.rightDir, i);
            if (FRAME.test(this.level.func_180495_p((BlockPos)blockpos$mutable), (IBlockReader)this.level, (BlockPos)blockpos$mutable)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(BlockPos.Mutable p_242969_1_) {
        for (int i = 0; i < 21; ++i) {
            p_242969_1_.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, -1);
            if (!FRAME.test(this.level.func_180495_p((BlockPos)p_242969_1_), (IBlockReader)this.level, (BlockPos)p_242969_1_)) {
                return i;
            }
            p_242969_1_.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, this.width);
            if (!FRAME.test(this.level.func_180495_p((BlockPos)p_242969_1_), (IBlockReader)this.level, (BlockPos)p_242969_1_)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                p_242969_1_.func_189533_g((Vector3i)this.bottomLeft).func_189534_c(Direction.UP, i).func_189534_c(this.rightDir, j);
                BlockState blockstate = this.level.func_180495_p((BlockPos)p_242969_1_);
                if (!PortalShape.isEmpty(blockstate)) {
                    return i;
                }
                if (!blockstate.func_203425_a(portal)) continue;
                ++this.numPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean isEmpty(BlockState p_196900_0_) {
        return p_196900_0_.func_196958_f() || p_196900_0_.func_235714_a_((ITag)BlockTags.field_232872_am_) || p_196900_0_.func_203425_a(portal);
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks() {
        BlockState blockstate = (BlockState)portal.func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)this.axis);
        BlockPos.func_218278_a((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.func_177967_a(Direction.UP, this.height - 1).func_177967_a(this.rightDir, this.width - 1)).forEach(p_242967_2_ -> this.level.func_180501_a(p_242967_2_, blockstate, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }

    public static Vector3d getRelativePosition(TeleportationRepositioner.Result p_242973_0_, Direction.Axis p_242973_1_, Vector3d p_242973_2_, EntitySize p_242973_3_) {
        double d4;
        double d2;
        double d0 = (double)p_242973_0_.field_243680_b - (double)p_242973_3_.field_220315_a;
        double d1 = (double)p_242973_0_.field_243681_c - (double)p_242973_3_.field_220316_b;
        BlockPos blockpos = p_242973_0_.field_243679_a;
        if (d0 > 0.0) {
            float f = (float)blockpos.func_243648_a(p_242973_1_) + p_242973_3_.field_220315_a / 2.0f;
            d2 = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(p_242973_2_.func_216370_a(p_242973_1_) - (double)f), (double)0.0, (double)d0), (double)0.0, (double)1.0);
        } else {
            d2 = 0.5;
        }
        if (d1 > 0.0) {
            Direction.Axis direction$axis = Direction.Axis.Y;
            d4 = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(p_242973_2_.func_216370_a(direction$axis) - (double)blockpos.func_243648_a(direction$axis)), (double)0.0, (double)d1), (double)0.0, (double)1.0);
        } else {
            d4 = 0.0;
        }
        Direction.Axis direction$axis1 = p_242973_1_ == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double d3 = p_242973_2_.func_216370_a(direction$axis1) - ((double)blockpos.func_243648_a(direction$axis1) + 0.5);
        return new Vector3d(d2, d4, d3);
    }

    public static PortalInfo createPortalInfo(ServerWorld world, TeleportationRepositioner.Result result, Direction.Axis axis, Vector3d pos, EntitySize size, Vector3d speed, float yRot, float xRot) {
        BlockPos blockpos = result.field_243679_a;
        BlockState blockstate = world.func_180495_p(blockpos);
        Direction.Axis direction$axis = blockstate.func_235903_d_((Property)BlockStateProperties.field_208199_z).orElse(Direction.Axis.X);
        double d0 = result.field_243680_b;
        double d1 = result.field_243681_c;
        int i = axis == direction$axis ? 0 : 90;
        Vector3d vec3 = axis == direction$axis ? speed : new Vector3d(speed.field_72449_c, speed.field_72448_b, -speed.field_72450_a);
        double d2 = (double)size.field_220315_a / 2.0 + (d0 - (double)size.field_220315_a) * pos.func_82615_a();
        double d3 = (d1 - (double)size.field_220316_b) * pos.func_82617_b();
        double d4 = 0.5 + pos.func_82616_c();
        boolean flag = direction$axis == Direction.Axis.X;
        Vector3d vec31 = new Vector3d((double)blockpos.func_177958_n() + (flag ? d2 : d4), (double)blockpos.func_177956_o() + d3, (double)blockpos.func_177952_p() + (flag ? d4 : d2));
        return new PortalInfo(vec31, vec3, yRot + (float)i, xRot);
    }
}

